/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.dto.UiDisplayField;
import org.teamapps.dto.UiField;
import org.teamapps.ux.component.field.AbstractField;

public class DisplayField
extends AbstractField<String> {
    private boolean showBorder;
    private boolean showHtml;
    private boolean removeStyleTags = true;

    public DisplayField() {
    }

    public DisplayField(boolean showBorder, boolean showHtml) {
        this();
        this.showBorder = showBorder;
        this.showHtml = showHtml;
    }

    public UiField createUiComponent() {
        UiDisplayField uiDisplayField = new UiDisplayField();
        this.mapAbstractFieldAttributesToUiField((UiField)uiDisplayField);
        uiDisplayField.setShowBorder(this.showBorder);
        uiDisplayField.setShowHtml(this.showHtml);
        uiDisplayField.setRemoveStyleTags(this.removeStyleTags);
        return uiDisplayField;
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public DisplayField setShowBorder(boolean showBorder) {
        this.showBorder = showBorder;
        this.queueCommandIfRendered(() -> new UiDisplayField.SetShowBorderCommand(this.getId(), showBorder));
        return this;
    }

    public boolean isShowHtml() {
        return this.showHtml;
    }

    public DisplayField setShowHtml(boolean showHtml) {
        this.showHtml = showHtml;
        this.queueCommandIfRendered(() -> new UiDisplayField.SetShowHtmlCommand(this.getId(), showHtml));
        return this;
    }

    public boolean isRemoveStyleTags() {
        return this.removeStyleTags;
    }

    public DisplayField setRemoveStyleTags(boolean removeStyleTags) {
        this.removeStyleTags = removeStyleTags;
        this.queueCommandIfRendered(() -> new UiDisplayField.SetRemoveStyleTagsCommand(this.getId(), removeStyleTags));
        return this;
    }
}

