/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.multicurrency;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.teamapps.dto.UiCurrencyField;
import org.teamapps.dto.UiCurrencyUnit;
import org.teamapps.dto.UiCurrencyValue;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextInputHandlingField;
import org.teamapps.ux.component.field.multicurrency.value.CurrencyUnit;
import org.teamapps.ux.component.field.multicurrency.value.CurrencyValue;
import org.teamapps.ux.session.SessionContext;

public class CurrencyField
extends AbstractField<CurrencyValue>
implements TextInputHandlingField {
    public final Event<String> onTextInput = new Event();
    public final Event<SpecialKey> onSpecialKeyPressed = new Event();
    private ULocale locale = SessionContext.current().getULocale();
    private List<CurrencyUnit> currencyUnits;
    private int fixedPrecision = -1;
    private boolean alphabeticKeysQueryEnabled = true;
    private boolean currencyBeforeAmount;
    private boolean currencySymbolsEnabled = true;

    public CurrencyField() {
        this(CurrencyUnit.getAllAvailableFromJdk());
    }

    public CurrencyField(List<CurrencyUnit> currencyUnits) {
        this.currencyUnits = currencyUnits;
    }

    public UiField createUiComponent() {
        UiCurrencyField field = new UiCurrencyField();
        this.mapAbstractFieldAttributesToUiField((UiField)field);
        field.setCurrencyUnits(this.currencyUnits.stream().map(unit -> unit.toUiCurrencyUnit(this.locale.toLocale())).collect(Collectors.toList()));
        field.setFixedPrecision(this.fixedPrecision);
        field.setShowCurrencyBeforeAmount(this.currencyBeforeAmount);
        field.setShowCurrencySymbol(this.currencySymbolsEnabled);
        field.setAlphaKeysQueryForCurrency(this.alphabeticKeysQueryEnabled);
        field.setLocale(this.locale.toLanguageTag());
        return field;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        this.defaultHandleTextInputEvent(event);
    }

    public List<CurrencyUnit> getCurrencyUnits() {
        return this.currencyUnits;
    }

    public CurrencyField setCurrencyUnits(List<CurrencyUnit> currencyUnits) {
        this.currencyUnits = currencyUnits;
        this.queueCommandIfRendered(() -> new UiCurrencyField.SetCurrencyUnitsCommand(this.getId(), currencyUnits != null ? currencyUnits.stream().map(unit -> unit.toUiCurrencyUnit(this.locale.toLocale())).collect(Collectors.toList()) : null));
        return this;
    }

    @Override
    public Object convertUxValueToUiValue(CurrencyValue currencyValue) {
        return currencyValue != null ? currencyValue.toUiCurrencyValue(this.locale.toLocale()) : null;
    }

    @Override
    public CurrencyValue convertUiValueToUxValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof UiCurrencyValue) {
            UiCurrencyValue uiCurrencyValue = (UiCurrencyValue)value;
            String uiAmount = uiCurrencyValue.getAmount();
            BigDecimal uxAmount = uiAmount != null ? new BigDecimal(uiAmount) : null;
            UiCurrencyUnit uiCurrencyUnit = uiCurrencyValue.getCurrencyUnit();
            CurrencyUnit uxCurrencyUnit = uiCurrencyUnit != null ? this.currencyUnits.stream().filter(cu -> cu.getCode().equals(uiCurrencyUnit.getCode()) && cu.getFractionDigits() == uiCurrencyUnit.getFractionDigits()).findFirst().orElseGet(() -> CurrencyUnit.from(uiCurrencyUnit.getCode(), uiCurrencyUnit.getFractionDigits(), uiCurrencyUnit.getName(), uiCurrencyUnit.getSymbol())) : null;
            return new CurrencyValue(uxCurrencyUnit, uxAmount);
        }
        throw new IllegalArgumentException("Unknown value type for CurrencyField: " + value.getClass().getCanonicalName());
    }

    public int getFixedPrecision() {
        return this.fixedPrecision;
    }

    public boolean isCurrencyBeforeAmount() {
        return this.currencyBeforeAmount;
    }

    public CurrencyField setCurrencyBeforeAmount(boolean currencyBeforeAmount) {
        this.currencyBeforeAmount = currencyBeforeAmount;
        this.queueCommandIfRendered(() -> new UiCurrencyField.SetShowCurrencyBeforeAmountCommand(this.getId(), currencyBeforeAmount));
        return this;
    }

    public boolean isCurrencySymbolsEnabled() {
        return this.currencySymbolsEnabled;
    }

    public CurrencyField setCurrencySymbolsEnabled(boolean currencySymbolsEnabled) {
        this.currencySymbolsEnabled = currencySymbolsEnabled;
        this.queueCommandIfRendered(() -> new UiCurrencyField.SetShowCurrencySymbolCommand(this.getId(), currencySymbolsEnabled));
        return this;
    }

    public boolean isAlphabeticKeysQueryEnabled() {
        return this.alphabeticKeysQueryEnabled;
    }

    public void setFixedPrecision(int fixedPrecision) {
        this.fixedPrecision = fixedPrecision;
        this.queueCommandIfRendered(() -> new UiCurrencyField.SetFixedPrecisionCommand(this.getId(), fixedPrecision));
    }

    public void setAlphabeticKeysQueryEnabled(boolean alphabeticKeysQueryEnabled) {
        this.alphabeticKeysQueryEnabled = alphabeticKeysQueryEnabled;
        this.reRenderIfRendered();
    }

    public Locale getLocale() {
        return this.locale.toLocale();
    }

    public ULocale getULocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.setULocale(ULocale.forLocale((Locale)locale));
    }

    public void setULocale(ULocale locale) {
        this.locale = locale;
        this.setCurrencyUnits(this.currencyUnits);
        this.queueCommandIfRendered(() -> new UiCurrencyField.SetLocaleCommand(this.getId(), locale.toLanguageTag()));
    }

    @Override
    public Event<String> onTextInput() {
        return this.onTextInput;
    }

    @Override
    public Event<SpecialKey> onSpecialKeyPressed() {
        return this.onSpecialKeyPressed;
    }
}

