/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.table;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.data.extract.ValueExtractor;
import org.teamapps.data.extract.ValueInjector;
import org.teamapps.dto.UiTableColumn;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;

public class TableColumn<RECORD, VALUE> {
    public static final int DEFAULT_WIDTH = 150;
    private Table<RECORD> table;
    private final String propertyName;
    private Icon<?, ?> icon;
    private String title;
    private AbstractField<VALUE> field;
    private int minWidth;
    private int defaultWidth;
    private int maxWidth;
    private boolean visible = true;
    private boolean sortable = true;
    private boolean resizeable = true;
    private boolean hiddenIfOnlyEmptyCellsVisible = false;
    private ValueExtractor<RECORD, VALUE> valueExtractor;
    private ValueInjector<RECORD, VALUE> valueInjector;
    private List<FieldMessage> messages = new ArrayList<FieldMessage>();

    public TableColumn(String propertyName, AbstractField<VALUE> field) {
        this(propertyName, null, null, field, 0, 150, 0);
    }

    public TableColumn(String propertyName, String title, AbstractField<VALUE> field) {
        this(propertyName, null, title, field, 0, 150, 0);
    }

    public TableColumn(String propertyName, Icon<?, ?> icon, String title, AbstractField<VALUE> field) {
        this(propertyName, icon, title, field, 0, 150, 0);
    }

    public TableColumn(String propertyName, Icon<?, ?> icon, String title, AbstractField<VALUE> field, int defaultWidth) {
        this(propertyName, icon, title, field, 0, defaultWidth, 0);
    }

    public TableColumn(String propertyName, Icon<?, ?> icon, String title, AbstractField<VALUE> field, int minWidth, int defaultWidth, int maxWidth) {
        this.propertyName = propertyName;
        this.icon = icon;
        this.title = title;
        this.field = field;
        this.minWidth = minWidth;
        this.defaultWidth = defaultWidth;
        this.maxWidth = maxWidth;
    }

    public UiTableColumn createUiTableColumn() {
        SessionContext context = CurrentSessionContext.get();
        UiTableColumn uiTableColumn = new UiTableColumn(this.propertyName, context.resolveIcon(this.icon), this.title, this.field.createUiReference());
        uiTableColumn.setDefaultWidth(this.defaultWidth);
        uiTableColumn.setMinWidth(this.minWidth);
        uiTableColumn.setDefaultWidth(this.defaultWidth);
        uiTableColumn.setMaxWidth(this.maxWidth);
        uiTableColumn.setSortable(this.sortable);
        uiTableColumn.setResizeable(this.resizeable);
        uiTableColumn.setVisible(this.visible);
        uiTableColumn.setHiddenIfOnlyEmptyCellsVisible(this.hiddenIfOnlyEmptyCellsVisible);
        uiTableColumn.setMessages(this.messages.stream().map(fieldMessage -> fieldMessage.createUiFieldMessage(FieldMessage.Position.POPOVER, FieldMessage.Visibility.ON_HOVER_OR_FOCUS)).collect(Collectors.toList()));
        return uiTableColumn;
    }

    public List<FieldMessage> getMessages() {
        return this.messages;
    }

    public void addMessage(FieldMessage message) {
        this.messages.add(message);
        if (this.table != null) {
            this.table.updateColumnMessages(this);
        }
    }

    public void removeMessage(FieldMessage message) {
        this.messages.remove(message);
        if (this.table != null) {
            this.table.updateColumnMessages(this);
        }
    }

    public void setMessages(List<FieldMessage> messages) {
        this.messages = messages;
        if (this.table != null) {
            this.table.updateColumnMessages(this);
        }
    }

    public Icon<?, ?> getIcon() {
        return this.icon;
    }

    public TableColumn<RECORD, VALUE> setIcon(Icon<?, ?> icon) {
        this.icon = icon;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public TableColumn<RECORD, VALUE> setTitle(String title) {
        this.title = title;
        return this;
    }

    public AbstractField<VALUE> getField() {
        return this.field;
    }

    public TableColumn<RECORD, VALUE> setField(AbstractField<VALUE> field) {
        this.field = field;
        return this;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public TableColumn<RECORD, VALUE> setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public TableColumn<RECORD, VALUE> setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
        return this;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public TableColumn<RECORD, VALUE> setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public TableColumn<RECORD, VALUE> setVisible(boolean visible) {
        this.visible = visible;
        if (this.table != null) {
            this.table.updateColumnVisibility(this);
        }
        return this;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public TableColumn<RECORD, VALUE> setSortable(boolean sortable) {
        this.sortable = sortable;
        return this;
    }

    public boolean isResizeable() {
        return this.resizeable;
    }

    public TableColumn<RECORD, VALUE> setResizeable(boolean resizeable) {
        this.resizeable = resizeable;
        return this;
    }

    public boolean isHiddenIfOnlyEmptyCellsVisible() {
        return this.hiddenIfOnlyEmptyCellsVisible;
    }

    public TableColumn<RECORD, VALUE> setHiddenIfOnlyEmptyCellsVisible(boolean hiddenIfOnlyEmptyCellsVisible) {
        this.hiddenIfOnlyEmptyCellsVisible = hiddenIfOnlyEmptyCellsVisible;
        return this;
    }

    void setTable(Table<RECORD> table) {
        this.table = table;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public ValueExtractor<RECORD, VALUE> getValueExtractor() {
        return this.valueExtractor;
    }

    public TableColumn<RECORD, VALUE> setValueExtractor(ValueExtractor<RECORD, VALUE> valueExtractor) {
        this.valueExtractor = valueExtractor;
        return this;
    }

    public ValueInjector<RECORD, VALUE> getValueInjector() {
        return this.valueInjector;
    }

    public TableColumn<RECORD, VALUE> setValueInjector(ValueInjector<RECORD, VALUE> valueInjector) {
        this.valueInjector = valueInjector;
        return this;
    }
}

