/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.databinding;

import org.teamapps.event.Event;
import org.teamapps.event.EventListener;

public class ObservableSessionValue<T> {
    private final Event<T> onChanged = new Event();
    private final Event<T> onBeforeChanged = new Event();
    private T value;
    private final boolean notifyOnChangeOnly;

    public ObservableSessionValue() {
        this(true);
    }

    public ObservableSessionValue(boolean notifyOnChangeOnly) {
        this.notifyOnChangeOnly = notifyOnChangeOnly;
    }

    public void set(T value) {
        if (this.notifyOnChangeOnly) {
            this.updateOnChange(value);
        } else {
            this.updateAlways(value);
        }
    }

    private void updateAlways(T value) {
        this.onBeforeChanged.fireIfChanged(value);
        this.value = value;
        this.onChanged.fireIfChanged(value);
    }

    private void updateOnChange(T value) {
        this.onBeforeChanged.fire(value);
        this.value = value;
        this.onChanged.fire(value);
    }

    public T get() {
        return this.value;
    }

    public void addOnChangeListener(EventListener<T> listener) {
        this.onChanged.addListener(listener);
    }

    public void removeOnChangeListener(EventListener<T> listener) {
        this.onChanged.removeListener(listener);
    }

    public void addOnBeforeChangeListener(EventListener<T> listener) {
        this.onBeforeChanged.addListener(listener);
    }

    public void removeBeforeOnChangeListener(EventListener<T> listener) {
        this.onBeforeChanged.removeListener(listener);
    }
}

