/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.perspective;

import java.util.List;
import org.teamapps.ux.application.layout.ExtendedLayout;
import org.teamapps.ux.application.perspective.PerspectiveChangeHandler;
import org.teamapps.ux.application.perspective.PerspectiveImpl;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.application.view.ViewSize;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;

public interface Perspective {
    public static Perspective createPerspective() {
        return new PerspectiveImpl(ExtendedLayout.createLayout());
    }

    public static Perspective createPerspective(LayoutItemDefinition layout) {
        return new PerspectiveImpl(layout);
    }

    public void addPerspectiveChangeHandler(PerspectiveChangeHandler var1);

    public void removePerspectiveChangeHandler(PerspectiveChangeHandler var1);

    public LayoutItemDefinition getLayout();

    public void setLayout(LayoutItemDefinition var1);

    default public void addViews(View ... views) {
        for (View view : views) {
            this.addView(view);
        }
    }

    public View addView(View var1);

    default public void addView(View view, String position) {
        this.addView(view);
        view.setLayoutPosition(position);
    }

    public void removeView(View var1);

    public List<View> getViews();

    public List<View> getVisibleViews();

    public List<View> getVisibleAndLayoutReferencedViews();

    public ToolbarButtonGroup addWorkspaceButtonGroup(ToolbarButtonGroup var1);

    public void removeWorkspaceButtonGroup(ToolbarButtonGroup var1);

    public List<ToolbarButtonGroup> getWorkspaceButtonGroups();

    default public void setFocusedView(View view) {
        view.focus();
    }

    default public void setViewPosition(View view, String position) {
        view.setLayoutPosition(position);
    }

    default public void setViewSize(View view, ViewSize viewSize) {
        view.setSize(viewSize);
    }
}

