/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.multicurrency;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.dto.UiCurrencyField;
import org.teamapps.dto.UiCurrencyValue;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextInputHandlingField;
import org.teamapps.ux.component.field.multicurrency.CurrencyValue;

public class CurrencyField
extends AbstractField<CurrencyValue>
implements TextInputHandlingField {
    public final Event<String> onTextInput = new Event();
    public final Event<SpecialKey> onSpecialKeyPressed = new Event();
    private int precision = 2;
    private boolean alphaKeysQueryForCurrency = true;
    private Currency defaultCurrency;
    private List<Currency> currencyList;
    private boolean showCurrencyBeforeAmount;
    private boolean showCurrencySymbol = true;

    public UiField createUiComponent() {
        UiCurrencyField field = new UiCurrencyField();
        this.mapAbstractFieldAttributesToUiField((UiField)field);
        field.setDefaultCurrencyCode(this.defaultCurrency != null ? this.defaultCurrency.isoCode : null);
        field.setCurrencyCodeList(this.currencyList != null ? this.currencyList.stream().map(Currency::getIsoCode).collect(Collectors.toList()) : null);
        field.setPrecision(this.precision);
        field.setShowCurrencyBeforeAmount(this.showCurrencyBeforeAmount);
        field.setShowCurrencySymbol(this.showCurrencySymbol);
        field.setAlphaKeysQueryForCurrency(this.alphaKeysQueryForCurrency);
        return field;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        this.defaultHandleTextInputEvent(event);
    }

    public Currency getDefaultCurrency() {
        return this.defaultCurrency;
    }

    public CurrencyField setDefaultCurrency(Currency defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
        this.queueCommandIfRendered(() -> new UiCurrencyField.SetDefaultCurrencyCodeCommand(this.getId(), defaultCurrency != null ? defaultCurrency.isoCode : null));
        return this;
    }

    public List<Currency> getCurrencyList() {
        return this.currencyList;
    }

    public CurrencyField setCurrencyList(List<Currency> currencyList) {
        this.currencyList = currencyList;
        this.queueCommandIfRendered(() -> new UiCurrencyField.SetCurrencyCodeListCommand(this.getId(), currencyList != null ? currencyList.stream().map(Currency::getIsoCode).collect(Collectors.toList()) : null));
        return this;
    }

    @Override
    public Object convertUxValueToUiValue(CurrencyValue currencyValue) {
        return currencyValue != null ? currencyValue.toUiCurrencyValue() : null;
    }

    @Override
    public CurrencyValue convertUiValueToUxValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof UiCurrencyValue) {
            UiCurrencyValue uiCurrencyValue = (UiCurrencyValue)value;
            return new CurrencyValue(uiCurrencyValue.getValue(), uiCurrencyValue.getCurrencyCode());
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new CurrencyValue(((Number)map.get("value")).longValue(), (String)map.get("currencyCode"));
        }
        throw new IllegalArgumentException("Unknown value type for CurrencyField: " + value.getClass().getCanonicalName());
    }

    @Override
    protected void doDestroy() {
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean isShowCurrencyBeforeAmount() {
        return this.showCurrencyBeforeAmount;
    }

    public CurrencyField setShowCurrencyBeforeAmount(boolean showCurrencyBeforeAmount) {
        this.showCurrencyBeforeAmount = showCurrencyBeforeAmount;
        this.queueCommandIfRendered(() -> new UiCurrencyField.SetShowCurrencyBeforeAmountCommand(this.getId(), showCurrencyBeforeAmount));
        return this;
    }

    public boolean isShowCurrencySymbol() {
        return this.showCurrencySymbol;
    }

    public CurrencyField setShowCurrencySymbol(boolean showCurrencySymbol) {
        this.showCurrencySymbol = showCurrencySymbol;
        this.queueCommandIfRendered(() -> new UiCurrencyField.SetShowCurrencySymbolCommand(this.getId(), showCurrencySymbol));
        return this;
    }

    public boolean isAlphaKeysQueryForCurrency() {
        return this.alphaKeysQueryForCurrency;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
        this.reRenderIfRendered();
    }

    public void setAlphaKeysQueryForCurrency(boolean alphaKeysQueryForCurrency) {
        this.alphaKeysQueryForCurrency = alphaKeysQueryForCurrency;
        this.reRenderIfRendered();
    }

    @Override
    public Event<String> onTextInput() {
        return this.onTextInput;
    }

    @Override
    public Event<SpecialKey> onSpecialKeyPressed() {
        return this.onSpecialKeyPressed;
    }

    public static enum Currency {
        AED("AED", null, "Dirhams", "United Arab Emirates Dirhams"),
        AFN("AFN", "\u060b", "Afghanis", "Afghan Afghanis"),
        ALL("ALL", "LEK", "Leke", "Albanian Lek"),
        AMD("AMD", null, "Drams", "Armenian Drams"),
        ANG("ANG", "\u0192", "Guilders", "Netherlands Antillean Guilders"),
        AOA("AOA", null, "Kwanza", "Angolan Kwanza"),
        ARS("ARS", "$", "Pesos", "Argentine Pesos"),
        AUD("AUD", "$", "Dollars", "Australian Dollars"),
        AWG("AWG", "\u0192", "Guilders", "Aruban Guilders"),
        AZN("AZN", "\u043c\u0430\u043d", "New Manats", "Azerbaijan New Manats"),
        BAM("BAM", "KM", "Convertible Marka", "Convertible Marka"),
        BBD("BBD", "$", "Dollars", "Barbados Dollars"),
        BDT("BDT", null, "Taka", "Bangladeshi Taka"),
        BGN("BGN", "\u043b\u0432", "Leva", "Bulgarian Leva"),
        BHD("BHD", null, "Dinars", "Bahraini Dinars"),
        BIF("BIF", null, "Francs", "Burundi Francs"),
        BMD("BMD", "$", "Dollars", "Bermudian Dollars"),
        BND("BND", "$", "Dollars", "Brunei Dollars"),
        BOB("BOB", "$b", "Bolivianos", "Bolivianos"),
        BRL("BRL", "R$", "Real", "Brazilian Real"),
        BSD("BSD", "$", "Dollars", "Bahamian Dollars"),
        BTN("BTN", null, "Ngultrum", "Bhutan Ngultrum"),
        BWP("BWP", "P", "Pulas", "Botswana Pulas"),
        BYR("BYR", "p.", "Rubles", "Belarussian Rubles"),
        BZD("BZD", "BZ$", "Dollars", "Belize Dollars"),
        CAD("CAD", "$", "Dollars", "Canadian Dollars"),
        CDF("CDF", null, "Franc", "Franc"),
        CHF("CHF", null, "Switzerland Francs", "Switzerland Francs"),
        CLP("CLP", "$", "Pesos", "Chilean Pesos"),
        CNY("CNY", "\u00a5", "Yuan Renminbi", "Yuan Renminbi"),
        COP("COP", "$", "Pesos", "Colombian Pesos"),
        CRC("CRC", "\u20a1", "Colones", "Costa Rican Colones"),
        CUP("CUP", "\u20b1", "Pesos", "Cuban Pesos"),
        CVE("CVE", null, "Escudos", "Cape Verde Escudos"),
        CZK("CZK", "K\u010d", "Koruny", "Czech Koruny"),
        DJF("DJF", null, "Francs", "Djibouti Francs"),
        DKK("DKK", "kr", "Kroner", "Danish Kroner"),
        DOP("DOP", "RD$", "Pesos", "Dominican Pesos"),
        DZD("DZD", null, "Dinars", "Algerian Dinar"),
        ECS("ECS", null, "Sucre", "Ecuador Sucre"),
        EEK("EEK", "kr", "Krooni", "Krooni"),
        EGP("EGP", "\u00a3", "Pounds", "Egyptian Pounds"),
        ETB("ETB", null, "Ethopia Birr", "Ethopia Birr"),
        EUR("EUR", "\u20ac", "Euro", "Euro"),
        FJD("FJD", null, "Dollar", "Fiji Dollar"),
        FKP("FKP", "\u00a3", "Pounds", "Falkland Islands Pounds"),
        GBP("GBP", "\u00a3", "Pounds", "Pound Sterling"),
        GEL("GEL", null, "Lari", "Lari"),
        GGP("GGP", "\u00a3", "Pounds", "Pound Sterling"),
        GHS("GHS", "\u00a2", "Cedis", "Ghanaian Cedis"),
        GIP("GIP", "\u00a3", "Pounds", "Gibraltar Pounds"),
        GMD("GMD", null, "Lari", "Gambian Dalasi"),
        GNF("GNF", null, "Francs", "Guinea Francs"),
        GTQ("GTQ", "Q", "Quetzales", "Quetzales"),
        GYD("GYD", null, "Dollars", "Guyana Dollars"),
        HKD("HKD", "$", "Dollars", "Hong Kong Dollars"),
        HNL("HNL", "L", "Lempiras", "Honduaran Lempiras"),
        HRK("HRK", "kn", "Kuna", "Croatian Kuna"),
        HTG("HTG", null, "Haitian Gourde", "Haitian Gourde"),
        HUF("HUF", "Ft", "Forint", "Hungarian Forint"),
        IDR("IDR", "Rp", "Indonesian Rupiahs", "Indonesian Rupiahs"),
        ILS("ILS", "\u20aa", "New Shekels", "New Shekels"),
        IMP("IMP", "\u00a3", "Pounds", "Pounds"),
        INR("INR", "\u20a8", "Rupees", "Indian Rupees"),
        IQD("IQD", null, "Dinars", "Iraqi Dinars"),
        IRR("IRR", "\ufdfc", "Riais", "Iranian Riais"),
        ISK("ISK", "kr", "Kronur", "Iceland Kronur"),
        JEP("JEP", "\u00a3", "Pounds", "Pounds"),
        JMD("JMD", null, "Dollars", "Jamaican Dollars"),
        JOD("JOD", null, "Dinars", "Jordanian Dinar"),
        JPY("JPY", "\u00a5", "Yen", "Japanese Yen"),
        KES("KES", null, "Shillings", "Kenyan Shillings"),
        KGS("KGS", "\u043b\u0432", "Soms", "Soms"),
        KHR("KHR", null, "Rieis", "Kampuchean Rieis"),
        KMF("KMF", null, "Francs", "Comoros Francs"),
        KPW("KPW", "\u20a9", "Won", "North Korean Won"),
        KRW("KRW", "\u20a9", "Won", "Korean Won"),
        KWD("KWD", null, "Dinars", "Kuwaiti Dinars"),
        KYD("KYD", "$", "Dollars", "Cayman Islands Dollars"),
        KZT("KZT", "\u043b\u0432", "Tenege", "Kazhakstan Tenege"),
        LAK("LAK", "\u20ad", "Kips", "Lao Kips"),
        LBP("LBP", "\u00a3", "Pounds", "Lebanese Pounds"),
        LKR("LKR", "\u20a8", "Rupees", "Sri Lanka Rupees"),
        LRD("LRD", "$", "Dollars", "Liberian Dollars"),
        LSL("LSL", null, "Maloti", "Lesotho Maloti"),
        LTL("LTL", "Lt", "Litai", "Lithuanian Litai"),
        LVL("LVL", "Ls", "Lati", "Latvian Lati"),
        LYD("LYD", null, "Dinars", "Libyan Dinars"),
        MAD("MAD", null, "Dirhams", "Moroccan Dirhams"),
        MDL("MDL", null, "Lei", "Moldovan Lei"),
        MKD("MKD", null, "Macedonian Denar", "Macedonian Denar"),
        MGA("MGA", null, "Ariary", "Ariary"),
        MMK("MMK", null, "Kyat", "Myanmar Kyat"),
        MNK("MNK", null, "Kyats", "Kyats"),
        MNT("MNT", "\u20ae", "Tugriks", "Mongolian Tugriks"),
        MRO("MRO", null, "Ouguiyas", "Mauritanian Ouguiyas"),
        MUR("MUR", "\u20a8", "Rupees", "Mauritius Rupees"),
        MVR("MVR", null, "Rufiyaa", "Maldive Rufiyaa"),
        MWK("MWK", null, "Kwachas", "Malawi Kwachas"),
        MXN("MXN", "$", "Pesos", "Mexican Nuevo Pesos"),
        MYR("MYR", "RM", "Ringgits", "Malaysian Ringgits"),
        MZN("MZN", "MT", "Meticals", "Mozambique Meticals"),
        NAD("NAD", "$", "Dollars", "Namibian Dollars"),
        NGN("NGN", "\u20a6", "Nairas", "Nigerian Nairas"),
        NIO("NIO", "C$", "Cordobas", "Nicaraguan Cordobas Oro"),
        NOK("NOK", "kr", "Kroner", "Norwegian Kroner"),
        NPR("NPR", "\u20a8", "Rupees", "Nepalese Rupees"),
        NZD("NZD", "$", "New Zealand Dollars", "New Zealand Dollars"),
        OMR("OMR", "\ufdfc", "Riais", "Riais"),
        PAB("PAB", "B/.", "Balboa", "Balboa"),
        PEN("PEN", "S/.", "Nuevos Soles", "Peru Nuevos Soles"),
        PGK("PGK", null, "Kina", "Kina"),
        PHP("PHP", "Php", "Pesos", "Phillippines Pesos"),
        PKR("PKR", "\u20a8", "Rupees", "Pakistani Rupees"),
        PLN("PLN", "z\u0142", "Zlotych", "Poland Zlotych"),
        PYG("PYG", "Gs", "Guarani", "Paraguay Guarani"),
        QAR("QAR", "\ufdfc", "Rials", "Qatar Rials"),
        RON("RON", "lei", "New Lei", "Romanian New Lei"),
        RSD("RSD", "\u0414\u0438\u043d.", "Dinars", "Serbia Dinars"),
        RUB("RUB", "\u0440\u0443\u0431", "Rubles", "Russia Rubles"),
        RWF("RWF", null, "Francs", "Francs"),
        SAR("SAR", "\ufdfc", "Riyals", "Saudi Arabia Riyals"),
        SBD("SBD", "$", "Dollars", "Solomon Islands Dollars"),
        SCR("SCR", "\u20a8", "Rupees", "Seychelles Rupees"),
        SDG("SDG", null, "Pounds", "Pounds"),
        SEK("SEK", "kr", "Kronor", "Sweden Kronor"),
        SGD("SGD", "$", "Dollars", "Singapore Dollars"),
        SHP("SHP", "\u00a3", "Pounds", "Saint Helena Pounds"),
        SLL("SLL", null, "Leones", "Leones"),
        SOS("SOS", "S", "Shillings", "Somalia Shillings"),
        SRD("SRD", "$", "Dollars", "SurifullName Dollars"),
        STD("STD", null, "Dobras", "Dobras"),
        SVC("SVC", null, "Salvadoran Col\u00f3n", "Salvadoran Col\u00f3n"),
        SYP("SYP", "\u00a3", "Pounds", "Syria Pounds"),
        SZL("SZL", null, "Emalangeni", "Emalangeni"),
        THB("THB", "\u0e3f", "Baht", "Thaliand Baht"),
        TJS("TJS", null, "Somoni", "Somoni"),
        TMM("TMM", null, "Manat", "Manat"),
        TND("TND", null, "Dinars", "Tunisian Dinars"),
        TOP("TOP", null, "Pa'anga", "Pa'anga"),
        TRY("TRY", "TL", "Lira", "Turkey Lira"),
        TTD("TTD", "$", "Dollars", "Trinidad and Tobago Dollars"),
        TVD("TVD", null, "Tuvalu Dollars", "Tuvalu Dollars"),
        TWD("TWD", "NT$", "New Dollars", "Taiwan New Dollars"),
        TZS("TZS", null, "Shillings", "Shillings"),
        UAH("UAH", "\u20b4", "Hryvnia", "Ukraine Hryvnia"),
        UGX("UGX", null, "Shillings", "Shillings"),
        USD("USD", "$", "Dollars", "United States Dollars"),
        UYU("UYU", "$U", "Pesos", "Uruguay Pesos"),
        UZS("UZS", "\u043b\u0432", "Sums", "Uzbekistan Sums"),
        VEF("VEF", "Bs", "Bolivares Fuertes", "Venezuela Bolivares Fuertes"),
        VND("VND", "\u20ab", "Dong", "Viet Nam Dong"),
        XAF("XAF", null, "Communaut\u00e9 Financi\u00e8re Africaine Francs", "Communaut\u00e9 Financi\u00e8re Africaine Francs"),
        XCD("XCD", "$", "East Caribbean Dollars", "East Caribbean Dollars"),
        XOF("XOF", null, "Communaut\u00e9 Financi\u00e8re Africaine Francs", "Communaut\u00e9 Financi\u00e8re Africaine Francs"),
        XPF("XPF", null, "Comptoirs Fran\u00e7ais du Pacifique Francs", "Comptoirs Fran\u00e7ais du Pacifique Francs"),
        YER("YER", "\ufdfc", "Rials", "Yemen Rials"),
        ZAR("ZAR", "R", "Rand", "South Africa Rand"),
        ZMK("ZMK", null, "Kwacha", "Kwacha"),
        ZWD("ZWD", "Z$", "Zimbabwe Dollars", "Zimbabwe Dollars");

        private final String isoCode;
        private final String symbol;
        private final String name;
        private final String fullName;

        private Currency(String isoCode, String symbol, String name, String fullName) {
            this.isoCode = isoCode;
            this.symbol = symbol;
            this.name = name;
            this.fullName = fullName;
        }

        public String getIsoCode() {
            return this.isoCode;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            return this.fullName;
        }
    }
}

