/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.form.layoutpolicy;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.common.format.Color;
import org.teamapps.dto.UiFormSection;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.form.layoutpolicy.FormSectionFieldPlacement;
import org.teamapps.ux.component.form.layoutpolicy.FormSectionPlacement;
import org.teamapps.ux.component.format.Border;
import org.teamapps.ux.component.format.Shadow;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.grid.layout.GridColumn;
import org.teamapps.ux.component.grid.layout.GridRow;
import org.teamapps.ux.component.template.Template;

public class FormSection {
    private final String id;
    private Spacing margin;
    private Spacing padding;
    private Border border;
    private Shadow shadow;
    private boolean drawHeaderLine = true;
    private Color backgroundColor;
    private List<GridColumn> columns = new ArrayList<GridColumn>();
    private List<GridRow> rows = new ArrayList<GridRow>();
    private List<FormSectionPlacement> fieldPlacements = new ArrayList<FormSectionPlacement>();
    private boolean collapsible;
    private boolean collapsed;
    private boolean visible = true;
    private Template headerTemplate;
    private Object headerData;
    private int gridGap = 5;
    private boolean fillRemainingHeight;
    private boolean hideWhenNoVisibleFields;

    public FormSection(String id) {
        this.id = id;
    }

    public FormSection createCopy(String id) {
        FormSection section = new FormSection(id);
        section.setMargin(this.margin);
        section.setPadding(this.padding);
        section.setBorder(this.border);
        section.setShadow(this.shadow);
        section.setDrawHeaderLine(this.drawHeaderLine);
        section.setBackgroundColor(this.backgroundColor);
        section.setCollapsible(this.collapsible);
        section.setCollapsed(this.collapsed);
        section.setVisible(this.visible);
        section.setHeaderTemplate(this.headerTemplate);
        section.setHeaderData(this.headerData);
        section.setGridGap(this.gridGap);
        section.setFillRemainingHeight(this.fillRemainingHeight);
        section.setHideWhenNoVisibleFields(this.hideWhenNoVisibleFields);
        return section;
    }

    public void add(GridColumn column) {
        this.columns.add(column);
    }

    public void add(GridRow row) {
        this.rows.add(row);
    }

    public void add(FormSectionFieldPlacement fieldPlacement) {
        this.fieldPlacements.add(fieldPlacement);
    }

    public String getId() {
        return this.id;
    }

    public Spacing getMargin() {
        return this.margin;
    }

    public FormSection setMargin(Spacing margin) {
        this.margin = margin;
        return this;
    }

    public Spacing getPadding() {
        return this.padding;
    }

    public FormSection setPadding(Spacing padding) {
        this.padding = padding;
        return this;
    }

    public Border getBorder() {
        return this.border;
    }

    public FormSection setBorder(Border border) {
        this.border = border;
        return this;
    }

    public Shadow getShadow() {
        return this.shadow;
    }

    public FormSection setShadow(Shadow shadow) {
        this.shadow = shadow;
        return this;
    }

    public boolean isDrawHeaderLine() {
        return this.drawHeaderLine;
    }

    public FormSection setDrawHeaderLine(boolean drawHeaderLine) {
        this.drawHeaderLine = drawHeaderLine;
        return this;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public FormSection setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public List<GridColumn> getColumns() {
        return this.columns;
    }

    public FormSection setColumns(List<GridColumn> columns) {
        this.columns = columns;
        return this;
    }

    public FormSection addColumn(GridColumn column) {
        this.columns.add(column);
        return this;
    }

    public List<GridRow> getRows() {
        return this.rows;
    }

    public FormSection addRow(GridRow row) {
        this.rows.add(row);
        return this;
    }

    public FormSection setRows(List<GridRow> rows) {
        this.rows = rows;
        return this;
    }

    public List<FormSectionPlacement> getPlacements() {
        return this.fieldPlacements;
    }

    public FormSection addPlacement(FormSectionPlacement fieldPlacement) {
        this.fieldPlacements.add(fieldPlacement);
        return this;
    }

    public FormSection setPlacements(List<FormSectionPlacement> fieldPlacements) {
        this.fieldPlacements = fieldPlacements;
        return this;
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public FormSection setCollapsible(boolean collapsible) {
        this.collapsible = collapsible;
        return this;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public FormSection setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public FormSection setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public Template getHeaderTemplate() {
        return this.headerTemplate;
    }

    public FormSection setHeaderTemplate(Template headerTemplate) {
        this.headerTemplate = headerTemplate;
        return this;
    }

    public Object getHeaderData() {
        return this.headerData;
    }

    public FormSection setHeaderData(Object headerData) {
        this.headerData = headerData;
        return this;
    }

    public int getGridGap() {
        return this.gridGap;
    }

    public FormSection setGridGap(int gridGap) {
        this.gridGap = gridGap;
        return this;
    }

    public boolean isFillRemainingHeight() {
        return this.fillRemainingHeight;
    }

    public FormSection setFillRemainingHeight(boolean fillRemainingHeight) {
        this.fillRemainingHeight = fillRemainingHeight;
        return this;
    }

    public boolean isHideWhenNoVisibleFields() {
        return this.hideWhenNoVisibleFields;
    }

    public FormSection setHideWhenNoVisibleFields(boolean hideWhenNoVisibleFields) {
        this.hideWhenNoVisibleFields = hideWhenNoVisibleFields;
        return this;
    }

    public UiFormSection createUiFormSection() {
        List uiColumns = this.columns.stream().map(column -> column != null ? column.createUiGridColumn() : null).collect(Collectors.toList());
        List rows = this.rows.stream().map(row -> row != null ? row.createUiGridRow() : null).collect(Collectors.toList());
        List uiFieldPlacements = this.fieldPlacements.stream().map(fieldPlacement -> fieldPlacement != null ? fieldPlacement.createUiFormSectionPlacement() : null).collect(Collectors.toList());
        UiFormSection uiSection = new UiFormSection(this.id, uiColumns, rows, uiFieldPlacements);
        uiSection.setMargin(this.margin != null ? this.margin.createUiSpacing() : null);
        uiSection.setPadding(this.padding != null ? this.padding.createUiSpacing() : null);
        uiSection.setBorder(this.border != null ? this.border.createUiBorder() : null);
        uiSection.setShadow(this.shadow != null ? this.shadow.createUiShadow() : null);
        uiSection.setDrawHeaderLine(this.drawHeaderLine);
        uiSection.setBackgroundColor(this.backgroundColor != null ? UiUtil.createUiColor(this.backgroundColor) : null);
        uiSection.setCollapsible(this.collapsible);
        uiSection.setCollapsed(this.collapsed);
        uiSection.setVisible(this.visible);
        uiSection.setHeaderTemplate(this.headerTemplate != null ? this.headerTemplate.createUiTemplate() : null);
        uiSection.setHeaderData(this.headerData);
        uiSection.setGridGap(this.gridGap);
        uiSection.setFillRemainingHeight(this.fillRemainingHeight);
        uiSection.setHideWhenNoVisibleFields(this.hideWhenNoVisibleFields);
        return uiSection;
    }
}

