/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.mobile;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiMobileLayout;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.Container;
import org.teamapps.ux.component.mobile.MobileLayoutAnimation;
import org.teamapps.ux.component.mobile.NavigationBar;
import org.teamapps.ux.component.toolbar.Toolbar;

public class MobileLayout
extends AbstractComponent
implements Container {
    protected Toolbar toolbar;
    protected final Set<Component> views = new HashSet<Component>();
    protected Component activeComponent;
    protected NavigationBar navigationBar;

    @Override
    public UiComponent createUiComponent() {
        UiMobileLayout uiMobileLayout = new UiMobileLayout();
        this.mapAbstractUiComponentProperties((UiComponent)uiMobileLayout);
        if (this.activeComponent != null) {
            uiMobileLayout.setInitialViewId(this.activeComponent.getId());
        }
        if (this.toolbar != null) {
            uiMobileLayout.setToolbar(this.toolbar.createUiComponentReference());
        }
        List uiComponents = this.views.stream().map(component -> component.createUiComponentReference()).collect(Collectors.toList());
        uiMobileLayout.setViews(uiComponents);
        uiMobileLayout.setNavigationBar(this.navigationBar != null ? this.navigationBar.createUiComponentReference() : null);
        return uiMobileLayout;
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    public void handleUiEvent(UiEvent event) {
    }

    public void preloadView(Component component) {
        this.views.add(component);
        component.setParent(this);
        this.queueCommandIfRendered(() -> new UiMobileLayout.AddViewCommand(this.getId(), component.createUiComponentReference()));
    }

    public void showView(Component component, MobileLayoutAnimation animation) {
        this.activeComponent = component;
        if (!this.views.contains(this.activeComponent)) {
            this.preloadView(component);
        }
        this.queueCommandIfRendered(() -> new UiMobileLayout.ShowViewCommand(this.getId(), component.getId(), animation.toUiMobileLayoutAnimation()));
    }

    public void removeView(Component component) {
        if (this.views.contains(component)) {
            this.views.remove(component);
            this.queueCommandIfRendered(() -> new UiMobileLayout.RemoveViewCommand(this.getId(), component.getId()));
        }
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public void setToolbar(Toolbar toolbar) {
        this.toolbar = toolbar;
    }

    public Component getActiveComponent() {
        return this.activeComponent;
    }

    public NavigationBar getNavigationBar() {
        return this.navigationBar;
    }

    public void setNavigationBar(NavigationBar navigationBar) {
        this.navigationBar = navigationBar;
        if (navigationBar != null) {
            navigationBar.setParent(this);
        }
        this.queueCommandIfRendered(() -> new UiMobileLayout.SetNavigationBarCommand(this.getId(), navigationBar != null ? navigationBar.createUiComponentReference() : null));
    }

    @Override
    public boolean isChildVisible(Component child) {
        return this.isEffectivelyVisible() && (child == this.navigationBar || child == this.activeComponent || child == this.toolbar);
    }
}

