/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiLineChartLineFormat;
import org.teamapps.dto.UiLongInterval;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.LineChartCurveType;
import org.teamapps.ux.component.timegraph.LineChartLineListener;
import org.teamapps.ux.component.timegraph.LineChartYScaleZoomMode;
import org.teamapps.ux.component.timegraph.ScaleType;

public class LineChartLine {
    private static Color[] LINE_BASE_COLORS = new Color[]{Color.MATERIAL_BLUE_500, Color.MATERIAL_TEAL_500, Color.MATERIAL_RED_500, Color.MATERIAL_DEEP_PURPLE_500, Color.MATERIAL_GREEN_500, Color.MATERIAL_GREY_500};
    private final String id;
    private LineChartLineListener changeListener;
    private LineChartCurveType graphType = LineChartCurveType.MONOTONE;
    private float dataDotRadius = 2.0f;
    private Color axisColor = Color.BLACK;
    private Color lineColorScaleMin = new Color(73, 128, 192);
    private Color lineColorScaleMax = new Color(73, 128, 192);
    private Color areaColorScaleMin = new Color(255, 255, 255, 0.0f);
    private Color areaColorScaleMax = new Color(255, 255, 255, 0.0f);
    private Interval intervalY;
    private ScaleType yScaleType = ScaleType.LINEAR;
    private LineChartYScaleZoomMode yScaleZoomMode = LineChartYScaleZoomMode.DYNAMIC_INCLUDING_ZERO;
    private boolean yZeroLineVisible = false;

    public static Color getBaseColor(int index) {
        return LINE_BASE_COLORS[index % LINE_BASE_COLORS.length];
    }

    public LineChartLine(String id) {
        this.id = id;
    }

    public LineChartLine(String id, LineChartCurveType graphType, float dataDotRadius, Color lineColor) {
        this(id, graphType, dataDotRadius, lineColor, lineColor, null, null);
    }

    public LineChartLine(String id, LineChartCurveType graphType, float dataDotRadius, Color lineColor, Color areaColor) {
        this(id, graphType, dataDotRadius, lineColor, lineColor, Color.withAlpha((Color)areaColor, (float)0.0f), areaColor);
    }

    public LineChartLine(String id, LineChartCurveType graphType, float dataDotRadius, Color lineColorScaleMin, Color lineColorScaleMax, Color areaColorScaleMin, Color areaColorScaleMax) {
        this.id = id;
        this.graphType = graphType;
        this.dataDotRadius = dataDotRadius;
        this.lineColorScaleMin = lineColorScaleMin;
        this.lineColorScaleMax = lineColorScaleMax;
        this.areaColorScaleMin = areaColorScaleMin;
        this.areaColorScaleMax = areaColorScaleMax;
    }

    public UiLineChartLineFormat createUiLineChartLineFormat() {
        UiLineChartLineFormat definition = new UiLineChartLineFormat();
        definition.setGraphType(this.graphType.toUiLineChartCurveType());
        definition.setDataDotRadius(this.dataDotRadius);
        definition.setLineColorScaleMin(this.lineColorScaleMin != null ? UiUtil.createUiColor(this.lineColorScaleMin) : null);
        definition.setLineColorScaleMax(this.lineColorScaleMax != null ? UiUtil.createUiColor(this.lineColorScaleMax) : null);
        definition.setAreaColorScaleMin(this.areaColorScaleMin != null ? UiUtil.createUiColor(this.areaColorScaleMin) : null);
        definition.setAreaColorScaleMax(this.areaColorScaleMax != null ? UiUtil.createUiColor(this.areaColorScaleMax) : null);
        definition.setAxisColor(this.axisColor != null ? UiUtil.createUiColor(this.axisColor) : null);
        definition.setIntervalY(this.intervalY != null ? this.intervalY.createUiLongInterval() : new UiLongInterval(0L, 1000L));
        definition.setYScaleType(this.yScaleType.toUiScaleType());
        definition.setYScaleZoomMode(this.yScaleZoomMode.toUiLineChartYScaleZoomMode());
        definition.setYZeroLineVisible(this.yZeroLineVisible);
        return definition;
    }

    public String getId() {
        return this.id;
    }

    public LineChartCurveType getGraphType() {
        return this.graphType;
    }

    public LineChartLine setGraphType(LineChartCurveType graphType) {
        this.graphType = graphType;
        if (this.changeListener != null) {
            this.changeListener.handleGraphTypeChanged(this, graphType);
        }
        return this;
    }

    public float getDataDotRadius() {
        return this.dataDotRadius;
    }

    public LineChartLine setDataDotRadius(float dataDotRadius) {
        this.dataDotRadius = dataDotRadius;
        if (this.changeListener != null) {
            this.changeListener.handleDataDotRadiusChanged(this, dataDotRadius);
        }
        return this;
    }

    public Color getLineColorScaleMin() {
        return this.lineColorScaleMin;
    }

    public LineChartLine setLineColorScaleMin(Color lineColorScaleMin) {
        this.lineColorScaleMin = lineColorScaleMin;
        if (this.changeListener != null) {
            this.changeListener.handleLineColorScaleMinChanged(this, lineColorScaleMin);
        }
        return this;
    }

    public Color getLineColorScaleMax() {
        return this.lineColorScaleMax;
    }

    public LineChartLine setLineColorScaleMax(Color lineColorScaleMax) {
        this.lineColorScaleMax = lineColorScaleMax;
        if (this.changeListener != null) {
            this.changeListener.handleLineColorScaleMaxChanged(this, lineColorScaleMax);
        }
        return this;
    }

    public Color getAreaColorScaleMin() {
        return this.areaColorScaleMin;
    }

    public LineChartLine setAreaColorScaleMin(Color areaColorScaleMin) {
        this.areaColorScaleMin = areaColorScaleMin;
        if (this.changeListener != null) {
            this.changeListener.handleAreaColorScaleMinChanged(this, areaColorScaleMin);
        }
        return this;
    }

    public Color getAreaColorScaleMax() {
        return this.areaColorScaleMax;
    }

    public LineChartLine setAreaColorScaleMax(Color areaColorScaleMax) {
        this.areaColorScaleMax = areaColorScaleMax;
        if (this.changeListener != null) {
            this.changeListener.handleAreaColorScaleMaxChanged(this, areaColorScaleMax);
        }
        return this;
    }

    public Interval getIntervalY() {
        return this.intervalY;
    }

    public LineChartLine setIntervalY(Interval intervalY) {
        this.intervalY = intervalY;
        if (this.changeListener != null) {
            this.changeListener.handleIntervalYChanged(this, intervalY);
        }
        return this;
    }

    public ScaleType getyScaleType() {
        return this.yScaleType;
    }

    public LineChartLine setYScaleType(ScaleType yScaleType) {
        this.yScaleType = yScaleType;
        if (this.changeListener != null) {
            this.changeListener.handleYScaleTypeChanged(this, yScaleType);
        }
        return this;
    }

    public LineChartYScaleZoomMode getYScaleZoomMode() {
        return this.yScaleZoomMode;
    }

    public LineChartLine setYScaleZoomMode(LineChartYScaleZoomMode yScaleZoomMode) {
        this.yScaleZoomMode = yScaleZoomMode;
        if (this.changeListener != null) {
            this.changeListener.handleYScaleZoomModeChanged(this, yScaleZoomMode);
        }
        return this;
    }

    void setChangeListener(LineChartLineListener listener) {
        this.changeListener = listener;
    }

    public Color getYAxisColor() {
        return this.axisColor;
    }

    public LineChartLine setAxisColor(Color axisColor) {
        this.axisColor = axisColor;
        if (this.changeListener != null) {
            this.changeListener.handleAxisColorChanged(this, axisColor);
        }
        return this;
    }

    public boolean isYZeroLineVisible() {
        return this.yZeroLineVisible;
    }

    public LineChartLine setYZeroLineVisible(boolean yZeroLineVisible) {
        this.yZeroLineVisible = yZeroLineVisible;
        if (this.changeListener != null) {
            this.changeListener.handleYZeroLineVisibleChanged(this, yZeroLineVisible);
        }
        return this;
    }
}

