/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.teamapps.ux.resource.Resource;

public class FileResource
implements Resource {
    private static final Map<String, String> MIMETYPES_BY_FILE_EXTENSION;
    private final File file;
    private final String name;

    public FileResource(File file) {
        this(file, file.getName());
    }

    public FileResource(File file, String name) {
        this.file = file;
        this.name = name;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public Date getLastModified() {
        return new Date(this.file.lastModified());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMimeType() {
        String fileType = this.getFileType();
        if (fileType == null) {
            return "application/octet-stream";
        }
        return MIMETYPES_BY_FILE_EXTENSION.getOrDefault(fileType, "application/octet-stream");
    }

    private String getFileType() {
        int pos = this.name.lastIndexOf(46);
        if (pos <= 0 || pos >= this.name.length() - 1) {
            return null;
        }
        return this.name.substring(pos + 1).toLowerCase();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public File getAsFile() {
        return this.file;
    }

    public String toString() {
        return "FileResource{file=" + this.file + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileResource that = (FileResource)o;
        return Objects.equals(this.file, that.file) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.name);
    }

    static {
        try {
            MIMETYPES_BY_FILE_EXTENSION = (Map)new ObjectMapper().readValue(FileResource.class.getResource("mimetypes-by-file-extension.json"), HashMap.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

