/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.uisession;

import java.util.Objects;

public class QualifiedUiSessionId {
    private final String httpSessionId;
    private final String uiSessionId;

    public QualifiedUiSessionId(String httpSessionId, String uiSessionId) {
        if (httpSessionId == null) {
            throw new NullPointerException("httpSessionId may not be null!");
        }
        if (uiSessionId == null) {
            throw new NullPointerException("uiSessionId may not be null!");
        }
        this.httpSessionId = httpSessionId;
        this.uiSessionId = uiSessionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedUiSessionId that = (QualifiedUiSessionId)o;
        return Objects.equals(this.httpSessionId, that.httpSessionId) && Objects.equals(this.uiSessionId, that.uiSessionId);
    }

    public int hashCode() {
        int result = this.httpSessionId.hashCode();
        result = 31 * result + this.uiSessionId.hashCode();
        return result;
    }

    public String toString() {
        return this.httpSessionId + ":" + this.uiSessionId;
    }

    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    public String getUiSessionId() {
        return this.uiSessionId;
    }
}

