/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.uisession;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.dto.AbstractServerMessage;
import org.teamapps.dto.INIT_NOK;
import org.teamapps.dto.INIT_OK;
import org.teamapps.dto.MULTI_CMD;
import org.teamapps.dto.PING;
import org.teamapps.dto.QUERY_RESULT;
import org.teamapps.dto.REINIT_NOK;
import org.teamapps.dto.REINIT_OK;
import org.teamapps.dto.UiClientInfo;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiQuery;
import org.teamapps.dto.UiSessionClosingReason;
import org.teamapps.uisession.CMD;
import org.teamapps.uisession.ClientBackPressureInfo;
import org.teamapps.uisession.CommandBuffer;
import org.teamapps.uisession.MessageSender;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.uisession.TeamAppsSessionNotFoundException;
import org.teamapps.uisession.UiCommandExecutor;
import org.teamapps.uisession.UiCommandWithResultCallback;
import org.teamapps.uisession.UiSessionListener;
import org.teamapps.uisession.UnconsumedCommandsOverflowException;

public class TeamAppsUiSessionManager
implements UiCommandExecutor,
HttpSessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TeamAppsUiSessionManager.class);
    private final ScheduledExecutorService houseKeepingScheduledExecutor;
    private final ObjectMapper objectMapper;
    private final TeamAppsConfiguration config;
    private final Table<String, String, UiSession> sessionsById = Tables.synchronizedTable((Table)HashBasedTable.create());
    private UiSessionListener uiSessionListener;

    public TeamAppsUiSessionManager(TeamAppsConfiguration config, ObjectMapper objectMapper) {
        this.config = config;
        if (config.getKeepaliveMessageIntervalMillis() >= config.getUiSessionInactivityTimeoutMillis() / 2L) {
            LOGGER.warn("keepaliveMessageIntervalMillis should be less than uiSessionInactivityTimeoutMillis / 2!");
        }
        this.objectMapper = objectMapper;
        this.houseKeepingScheduledExecutor = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("TeamAppsUiSessionManager.houseKeeping");
            thread.setDaemon(true);
            return thread;
        });
        long sessionStateHouseKeepingInterval = config.getUiSessionInactivityTimeoutMillis() / 8L;
        this.houseKeepingScheduledExecutor.scheduleAtFixedRate(() -> {
            try {
                this.updateSessionStates();
            }
            catch (Exception e) {
                LOGGER.error("Exception while updating session states!", (Throwable)e);
            }
        }, sessionStateHouseKeepingInterval, sessionStateHouseKeepingInterval, TimeUnit.MILLISECONDS);
    }

    public void setUiSessionListener(UiSessionListener uiSessionListener) {
        this.uiSessionListener = uiSessionListener;
    }

    private UiSession getSessionById(QualifiedUiSessionId sessionId) {
        return (UiSession)this.sessionsById.get((Object)sessionId.getHttpSessionId(), (Object)sessionId.getUiSessionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSession(QualifiedUiSessionId sessionId, UiClientInfo clientInfo, HttpSession httpSession, int maxRequestedCommandId, MessageSender messageSender) {
        UiSession session;
        LOGGER.trace("initSession: sessionId = [" + sessionId + "], clientInfo = [" + clientInfo + "], maxRequestedCommandId = [" + maxRequestedCommandId + "], messageSender = [" + messageSender + "]");
        boolean isRefresh = false;
        Table<String, String, UiSession> table = this.sessionsById;
        synchronized (table) {
            if (this.sessionsById.contains((Object)sessionId.getHttpSessionId(), (Object)sessionId.getUiSessionId())) {
                isRefresh = true;
                session = this.getSessionById(sessionId);
            } else {
                session = new UiSession(sessionId, clientInfo, httpSession, System.currentTimeMillis(), this.uiSessionListener, messageSender);
                this.sessionsById.put((Object)sessionId.getHttpSessionId(), (Object)sessionId.getUiSessionId(), (Object)session);
            }
        }
        if (isRefresh) {
            if (session != null) {
                session.handleClientRefresh(maxRequestedCommandId, messageSender);
            } else {
                messageSender.sendMessageAsynchronously((AbstractServerMessage)new INIT_NOK(UiSessionClosingReason.SESSION_NOT_FOUND), null);
            }
        } else {
            session.init(maxRequestedCommandId);
        }
    }

    public void handleEvent(QualifiedUiSessionId sessionId, int clientMessageId, UiEvent event) {
        UiSession session = this.getSessionById(sessionId);
        if (session == null) {
            throw new TeamAppsSessionNotFoundException(sessionId);
        }
        session.handleEvent(clientMessageId, event);
    }

    public void handleQuery(QualifiedUiSessionId sessionId, int clientMessageId, UiQuery uiQuery) {
        UiSession session = this.getSessionById(sessionId);
        if (session == null) {
            throw new TeamAppsSessionNotFoundException(sessionId);
        }
        session.handleQuery(clientMessageId, uiQuery);
    }

    public void handleCommandResult(QualifiedUiSessionId sessionId, int clientMessageId, int cmdId, Object result) {
        UiSession session = this.getSessionById(sessionId);
        if (session == null) {
            throw new TeamAppsSessionNotFoundException(sessionId);
        }
        session.handleCommandResult(clientMessageId, cmdId, result);
    }

    public void handleKeepAlive(QualifiedUiSessionId sessionId) {
        UiSession session = this.getSessionById(sessionId);
        if (session == null) {
            throw new TeamAppsSessionNotFoundException(sessionId);
        }
        session.handleKeepAlive();
    }

    public void reinitSession(QualifiedUiSessionId sessionId, int lastReceivedCommandId, int maxRequestedCommandId, MessageSender messageSender) {
        UiSession session = this.getSessionById(sessionId);
        if (session != null) {
            session.reinit(lastReceivedCommandId, maxRequestedCommandId, messageSender);
        } else {
            LOGGER.warn("Could not find teamAppsUiSession for REINIT: " + sessionId);
            messageSender.sendMessageAsynchronously((AbstractServerMessage)new REINIT_NOK(UiSessionClosingReason.SESSION_NOT_FOUND), null);
        }
    }

    public void handleCommandRequest(QualifiedUiSessionId qualifiedUiSessionId, int lastReceivedCommandId, int maxRequestedCommandId) {
        UiSession session = this.getSessionById(qualifiedUiSessionId);
        if (session == null) {
            throw new TeamAppsSessionNotFoundException(qualifiedUiSessionId);
        }
        session.handleCommandRequest(lastReceivedCommandId, maxRequestedCommandId);
    }

    @Override
    public int sendCommand(QualifiedUiSessionId sessionId, UiCommandWithResultCallback commandWithCallback) {
        UiSession session = this.getSessionById(sessionId);
        if (session != null) {
            return session.sendCommand(commandWithCallback);
        }
        LOGGER.debug("Cannot send command to non-existing session: " + sessionId);
        return -1;
    }

    @Override
    public ClientBackPressureInfo getClientBackPressureInfo(QualifiedUiSessionId sessionId) {
        UiSession session = this.getSessionById(sessionId);
        if (session != null) {
            return session.getClientBackPressureInfo();
        }
        LOGGER.info("Cannot get back pressure info for non-existing session: " + sessionId);
        return null;
    }

    @Override
    public void closeSession(QualifiedUiSessionId sessionId, UiSessionClosingReason reason) {
        LOGGER.info("Closing session: " + sessionId + " for reason: " + reason);
        UiSession removedSession = (UiSession)this.sessionsById.remove((Object)sessionId.getHttpSessionId(), (Object)sessionId.getUiSessionId());
        if (removedSession == null) {
            LOGGER.info("Session to be closed not found: " + sessionId);
        } else {
            removedSession.close(reason);
        }
        this.uiSessionListener.onUiSessionClosed(sessionId, reason);
    }

    public void sessionCreated(HttpSessionEvent se) {
        se.getSession().setMaxInactiveInterval(this.config.getHttpSessionTimeoutSeconds());
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.closeAllSessionsForHttpSession(se.getSession().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllSessionsForHttpSession(String httpSessionId) {
        ArrayList sessionsToClose;
        LOGGER.trace("TeamAppsUiSessionManager.removeAllSessionsForHttpSession");
        Table<String, String, UiSession> table = this.sessionsById;
        synchronized (table) {
            Map sessionsToBeClosed = this.sessionsById.row((Object)httpSessionId);
            sessionsToClose = new ArrayList(sessionsToBeClosed.values());
            sessionsToBeClosed.clear();
        }
        for (UiSession uiSession : sessionsToClose) {
            this.closeSession(uiSession.sessionId, UiSessionClosingReason.HTTP_SESSION_CLOSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSessionStates() {
        List sessionsToClose;
        Map<SessionActivityState, List<UiSession>> sessionsByActivity;
        long now = System.currentTimeMillis();
        Table<String, String, UiSession> table = this.sessionsById;
        synchronized (table) {
            sessionsByActivity = this.sessionsById.values().stream().collect(Collectors.groupingBy(session -> {
                long timeSinceLastMessage = now - session.getTimestampOfLastMessageFromClient();
                return timeSinceLastMessage > this.config.getUiSessionInactivityTimeoutMillis() ? SessionActivityState.INACTIVE : (timeSinceLastMessage > this.config.getUiSessionInactivityTimeoutMillis() * 3L / 4L ? SessionActivityState.NEARLY_INACTIVE : SessionActivityState.ACTIVE);
            }));
            sessionsToClose = this.sessionsById.values().stream().filter(session -> now - session.getTimestampOfLastMessageFromClient() > this.config.getUiSessionTimeoutMillis()).collect(Collectors.toList());
        }
        for (UiSession inactiveSession : sessionsByActivity.getOrDefault((Object)SessionActivityState.INACTIVE, List.of())) {
            if (!inactiveSession.taggedActive) continue;
            LOGGER.info("Marking session inactive: {}", (Object)inactiveSession.sessionId);
            inactiveSession.taggedActive = false;
            this.uiSessionListener.onActivityStateChanged(inactiveSession.sessionId, false);
        }
        for (UiSession criticalSession : sessionsByActivity.getOrDefault((Object)SessionActivityState.NEARLY_INACTIVE, List.of())) {
            if (!criticalSession.taggedActive) continue;
            LOGGER.info("Sending PING to client: {}", (Object)criticalSession.sessionId);
            criticalSession.sendAsyncWithErrorHandler((AbstractServerMessage)new PING());
        }
        for (UiSession activeSession : sessionsByActivity.getOrDefault((Object)SessionActivityState.ACTIVE, List.of())) {
            if (activeSession.taggedActive) continue;
            LOGGER.info("Marking session active: {}", (Object)activeSession.sessionId);
            activeSession.taggedActive = true;
            this.uiSessionListener.onActivityStateChanged(activeSession.sessionId, true);
        }
        for (UiSession sessionToClose : sessionsToClose) {
            this.closeSession(sessionToClose.sessionId, UiSessionClosingReason.SESSION_TIMEOUT);
        }
    }

    public void destroy() {
        this.houseKeepingScheduledExecutor.shutdown();
    }

    private class UiSession {
        private final QualifiedUiSessionId sessionId;
        private final UiClientInfo clientInfo;
        private final HttpSession httpSession;
        private final UiSessionListener sessionListener;
        private MessageSender messageSender;
        private final CommandBuffer commandBuffer;
        private final AtomicInteger commandIdCounter;
        private final AtomicLong timestampOfLastMessageFromClient;
        private int lastReceivedClientMessageId;
        private boolean clientReadyToReceiveCommands;
        private boolean taggedActive;
        private int maxRequestedCommandId;
        private int lastSentCommandId;
        private long requestedCommandsZeroTimestamp;
        private final Map<Integer, Consumer> resultCallbacksByCmdId;

        public UiSession(QualifiedUiSessionId sessionId, UiClientInfo clientInfo, HttpSession httpSession, long creationTime, UiSessionListener sessionListener, MessageSender messageSender) {
            this.commandBuffer = new CommandBuffer(TeamAppsUiSessionManager.this.config.getCommandBufferSize());
            this.commandIdCounter = new AtomicInteger();
            this.timestampOfLastMessageFromClient = new AtomicLong();
            this.clientReadyToReceiveCommands = true;
            this.taggedActive = true;
            this.maxRequestedCommandId = 0;
            this.requestedCommandsZeroTimestamp = -1L;
            this.resultCallbacksByCmdId = new ConcurrentHashMap<Integer, Consumer>();
            this.sessionId = sessionId;
            this.clientInfo = clientInfo;
            this.httpSession = httpSession;
            this.timestampOfLastMessageFromClient.set(creationTime);
            this.sessionListener = sessionListener;
            this.messageSender = messageSender;
        }

        public long getTimestampOfLastMessageFromClient() {
            return this.timestampOfLastMessageFromClient.get();
        }

        public void setMessageSender(MessageSender messageSender) {
            this.messageSender = messageSender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int sendCommand(UiCommandWithResultCallback commandWithCallback) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sending command ({}): {}", (Object)this.sessionId.getUiSessionId().substring(0, 8), (Object)commandWithCallback.getUiCommand().getClass().getSimpleName());
            }
            CMD cmd = this.createCMD(commandWithCallback);
            UiSession uiSession = this;
            synchronized (uiSession) {
                try {
                    this.commandBuffer.addCommand(cmd);
                }
                catch (UnconsumedCommandsOverflowException e) {
                    LOGGER.error("Too many unconsumed commands!", (Throwable)e);
                    TeamAppsUiSessionManager.this.closeSession(this.sessionId, UiSessionClosingReason.COMMANDS_OVERFLOW);
                    return -1;
                }
                this.sendAllQueuedCommandsIfPossible();
                return this.commandBuffer.getUnconsumedCommandsCount();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClientBackPressureInfo getClientBackPressureInfo() {
            UiSession uiSession = this;
            synchronized (uiSession) {
                return new ClientBackPressureInfo(TeamAppsUiSessionManager.this.config.getCommandBufferSize(), this.commandBuffer.getUnconsumedCommandsCount(), TeamAppsUiSessionManager.this.config.getClientMinRequestedCommands(), TeamAppsUiSessionManager.this.config.getClientMaxRequestedCommands(), this.maxRequestedCommandId - this.lastSentCommandId, this.requestedCommandsZeroTimestamp);
            }
        }

        private CMD createCMD(UiCommandWithResultCallback commandWithCallback) {
            CMD cmd;
            try {
                int cmdId = this.commandIdCounter.incrementAndGet();
                cmd = new CMD(cmdId, TeamAppsUiSessionManager.this.objectMapper.writeValueAsString(commandWithCallback.getUiCommand()));
                if (commandWithCallback.getResultCallback() != null) {
                    cmd.setAwaitsResponse(true);
                    this.resultCallbacksByCmdId.put(cmdId, commandWithCallback.getResultCallback());
                }
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return cmd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean rewindToCommand(int commandId) {
            UiSession uiSession = this;
            synchronized (uiSession) {
                this.lastSentCommandId = commandId - 1;
                return this.commandBuffer.rewindToCommand(commandId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendAllQueuedCommandsIfPossible() {
            if (this.clientReadyToReceiveCommands) {
                ArrayList<CMD> cmdsToSend = new ArrayList<CMD>();
                UiSession uiSession = this;
                synchronized (uiSession) {
                    while (this.clientReadyToReceiveCommands) {
                        if (this.lastSentCommandId >= this.maxRequestedCommandId) {
                            this.clientReadyToReceiveCommands = false;
                            this.requestedCommandsZeroTimestamp = System.currentTimeMillis();
                            break;
                        }
                        this.requestedCommandsZeroTimestamp = -1L;
                        CMD cmd = this.commandBuffer.consumeCommand();
                        if (cmd == null) break;
                        this.lastSentCommandId = cmd.getId();
                        cmdsToSend.add(cmd);
                    }
                }
                if (!cmdsToSend.isEmpty()) {
                    this.sendAsyncWithErrorHandler((AbstractServerMessage)new MULTI_CMD(cmdsToSend));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reviveConnection() {
            UiSession uiSession = this;
            synchronized (uiSession) {
                this.clientReadyToReceiveCommands = true;
                this.sendAllQueuedCommandsIfPossible();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleCommandRequest(int lastReceivedCommandId, int maxRequestedCommandId) {
            LOGGER.trace("UiSession.requestCommands: maxRequestedCommandId = [" + maxRequestedCommandId + "]");
            this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
            UiSession uiSession = this;
            synchronized (uiSession) {
                this.commandBuffer.purgeTillCommand(lastReceivedCommandId);
                this.maxRequestedCommandId = Math.max(maxRequestedCommandId, this.maxRequestedCommandId);
                this.reviveConnection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(int maxRequestedCommandId) {
            this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
            UiSession uiSession = this;
            synchronized (uiSession) {
                this.maxRequestedCommandId = maxRequestedCommandId;
            }
            LOGGER.debug("INIT successful: " + this.sessionId);
            this.sendAsyncWithErrorHandler((AbstractServerMessage)new INIT_OK(TeamAppsUiSessionManager.this.config.getClientMinRequestedCommands(), TeamAppsUiSessionManager.this.config.getClientMaxRequestedCommands(), TeamAppsUiSessionManager.this.config.getClientEventsBufferSize(), TeamAppsUiSessionManager.this.config.getKeepaliveMessageIntervalMillis()));
            this.sessionListener.onUiSessionStarted(this.sessionId, this.clientInfo, this.httpSession);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleClientRefresh(int maxRequestedCommandId, MessageSender messageSender) {
            this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
            UiSession uiSession = this;
            synchronized (uiSession) {
                this.messageSender = messageSender;
                this.commandBuffer.clear();
                this.commandIdCounter.set(0);
                this.lastReceivedClientMessageId = -1;
                this.clientReadyToReceiveCommands = true;
                this.maxRequestedCommandId = maxRequestedCommandId;
                this.lastSentCommandId = 0;
            }
            LOGGER.debug("INIT (client refresh) successful: " + this.sessionId);
            this.sendAsyncWithErrorHandler((AbstractServerMessage)new INIT_OK(TeamAppsUiSessionManager.this.config.getClientMinRequestedCommands(), TeamAppsUiSessionManager.this.config.getClientMaxRequestedCommands(), TeamAppsUiSessionManager.this.config.getClientEventsBufferSize(), TeamAppsUiSessionManager.this.config.getKeepaliveMessageIntervalMillis()));
            this.sessionListener.onUiSessionClientRefresh(this.sessionId, this.clientInfo, this.httpSession);
        }

        public void handleEvent(int clientMessageId, UiEvent event) {
            this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Recieved event ({}): {}", (Object)this.sessionId.getUiSessionId().substring(0, 8), (Object)event.getUiEventType());
            }
            this.updateClientMessageId(clientMessageId);
            this.reviveConnection();
            this.sessionListener.onUiEvent(this.sessionId, event).exceptionally(e -> {
                LOGGER.error("Exception while handling ui event", e);
                TeamAppsUiSessionManager.this.closeSession(this.sessionId, UiSessionClosingReason.SERVER_SIDE_ERROR);
                return null;
            });
        }

        public void handleQuery(int clientMessageId, UiQuery query) {
            this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Recieved query ({}): {}", (Object)this.sessionId.getUiSessionId().substring(0, 8), (Object)query.getUiQueryType());
            }
            this.updateClientMessageId(clientMessageId);
            this.reviveConnection();
            this.sessionListener.onUiQuery(this.sessionId, query, result -> this.sendAsyncWithErrorHandler((AbstractServerMessage)new QUERY_RESULT(clientMessageId, result)), exception -> {
                LOGGER.error("Exception while handling ui event", exception);
                TeamAppsUiSessionManager.this.closeSession(this.sessionId, UiSessionClosingReason.SERVER_SIDE_ERROR);
            });
        }

        public void handleCommandResult(int clientMessageId, int cmdId, Object result) {
            this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Recieved command result ({}): {}", (Object)this.sessionId.getUiSessionId().substring(0, 8));
            }
            this.updateClientMessageId(clientMessageId);
            this.reviveConnection();
            Consumer resultCallback = this.resultCallbacksByCmdId.remove(cmdId);
            if (resultCallback != null) {
                resultCallback.accept(result);
            } else {
                LOGGER.error("Could not find result callback for CMD_RESULT! cmdId: " + cmdId);
            }
        }

        private void updateClientMessageId(int clientMessageId) {
            if (this.lastReceivedClientMessageId != -1 && clientMessageId != this.lastReceivedClientMessageId + 1) {
                LOGGER.warn("Missing event from client? Expected event id: " + this.lastReceivedClientMessageId + "1; Got: " + clientMessageId);
            }
            this.lastReceivedClientMessageId = clientMessageId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reinit(int lastReceivedCommandId, int maxRequestedCommandId, MessageSender messageSender) {
            this.setMessageSender(messageSender);
            if (this.rewindToCommand(lastReceivedCommandId)) {
                LOGGER.debug("REINIT successful: " + this.sessionId);
                UiSession uiSession = this;
                synchronized (uiSession) {
                    this.maxRequestedCommandId = Math.max(maxRequestedCommandId, this.maxRequestedCommandId);
                }
                this.sendAsyncWithErrorHandler((AbstractServerMessage)new REINIT_OK(this.lastReceivedClientMessageId));
                this.reviveConnection();
            } else {
                LOGGER.warn("Could not reinit. Command with id " + lastReceivedCommandId + "not found in command buffer.");
                this.sendAsyncWithErrorHandler((AbstractServerMessage)new REINIT_NOK(UiSessionClosingReason.REINIT_COMMAND_ID_NOT_FOUND));
            }
        }

        private void sendAsyncWithErrorHandler(AbstractServerMessage message) {
            long sendTime = System.currentTimeMillis();
            this.messageSender.sendMessageAsynchronously(message, exception -> {
                if (this.timestampOfLastMessageFromClient.get() <= sendTime) {
                    this.clientReadyToReceiveCommands = false;
                }
            });
        }

        public void handleKeepAlive() {
            this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
            this.reviveConnection();
        }

        public void close(UiSessionClosingReason reason) {
            this.messageSender.close(reason, null);
        }
    }

    static enum SessionActivityState {
        ACTIVE,
        NEARLY_INACTIVE,
        INACTIVE;

    }
}

