/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.chat;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.teamapps.event.Event;
import org.teamapps.ux.component.chat.AbstractChatDisplayModel;
import org.teamapps.ux.component.chat.ChatMessage;
import org.teamapps.ux.component.chat.ChatMessageBatch;

public class InMemoryChatDisplayModel
extends AbstractChatDisplayModel {
    private final CopyOnWriteArrayList<ChatMessage> messages = new CopyOnWriteArrayList();

    public InMemoryChatDisplayModel() {
    }

    public InMemoryChatDisplayModel(CopyOnWriteArrayList<ChatMessage> messages) {
        this.messages.addAll(messages);
    }

    @Override
    public Event<ChatMessageBatch> onMessagesAdded() {
        return this.onMessagesAdded;
    }

    @Override
    public Event<Void> onAllDataChanged() {
        return this.onAllDataChanged;
    }

    @Override
    public ChatMessageBatch getPreviousMessages(String earliestKnownMessageId, int numberOfMessages) {
        if (earliestKnownMessageId == null) {
            int startIndex = Math.max(0, this.messages.size() - numberOfMessages);
            return new ChatMessageBatch(this.messages.subList(startIndex, this.messages.size()), startIndex == 0);
        }
        int i = this.indexOfMessageById(earliestKnownMessageId);
        if (i == -1) {
            return new ChatMessageBatch(Collections.emptyList(), false);
        }
        int startIndex = Math.max(0, i - numberOfMessages);
        return new ChatMessageBatch(this.messages.subList(startIndex, i), startIndex == 0);
    }

    @Override
    public ChatMessage getChatMessageById(String id) {
        return this.messages.get(this.indexOfMessageById(id));
    }

    private int indexOfMessageById(String earliestKnownMessageId) {
        for (int i = this.messages.size() - 1; i > 0; --i) {
            if (!this.messages.get(i).getId().equals(earliestKnownMessageId)) continue;
            return i;
        }
        return -1;
    }

    public void addMessage(ChatMessage message) {
        boolean firstMessage = this.messages.size() == 0;
        this.messages.add(message);
        this.onMessagesAdded.fire(new ChatMessageBatch(Collections.singletonList(message), firstMessage));
    }

    public void replaceAllMessages(List<ChatMessage> messages) {
        this.messages.clear();
        this.messages.addAll(messages);
        this.onAllDataChanged.fire(null);
    }

    public void deleteMessage(String messageId) {
        ChatMessage message = this.messages.get(this.indexOfMessageById(messageId));
    }
}

