/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.multicurrency.value;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Optional;
import org.teamapps.dto.UiCurrencyValue;
import org.teamapps.ux.component.field.multicurrency.value.CurrencyUnit;

public class CurrencyValue {
    private final CurrencyUnit currency;
    private final BigDecimal amount;

    public CurrencyValue(CurrencyUnit currency, BigDecimal amount) {
        this.currency = currency;
        this.amount = amount;
    }

    public Optional<CurrencyUnit> getCurrency() {
        return Optional.ofNullable(this.currency);
    }

    public Optional<BigDecimal> getAmount() {
        return Optional.ofNullable(this.amount);
    }

    public Optional<Long> getAmountAsLong(int pointRightShift) {
        return this.getAmount().map(amount -> amount.movePointRight(pointRightShift).longValue());
    }

    public CurrencyValue withAmount(BigDecimal amount) {
        return new CurrencyValue(this.currency, amount);
    }

    public CurrencyValue withCurrencyUnit(CurrencyUnit currencyUnit) {
        return new CurrencyValue(currencyUnit, this.amount);
    }

    public UiCurrencyValue toUiCurrencyValue(Locale locale) {
        return new UiCurrencyValue(this.currency != null ? this.currency.toUiCurrencyUnit(locale) : null, this.amount != null ? this.amount.toString() : null);
    }
}

