/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.uisession;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.dto.AbstractServerMessage;
import org.teamapps.dto.INIT_OK;
import org.teamapps.dto.MULTI_CMD;
import org.teamapps.dto.PING;
import org.teamapps.dto.QUERY_RESULT;
import org.teamapps.dto.REINIT_NOK;
import org.teamapps.dto.REINIT_OK;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiQuery;
import org.teamapps.dto.UiSessionClosingReason;
import org.teamapps.uisession.CMD;
import org.teamapps.uisession.ClientBackPressureInfo;
import org.teamapps.uisession.CommandBuffer;
import org.teamapps.uisession.MessageSender;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.uisession.UiCommandWithResultCallback;
import org.teamapps.uisession.UiSessionListener;
import org.teamapps.uisession.UnconsumedCommandsOverflowException;
import org.teamapps.uisession.statistics.RunningUiSessionStats;
import org.teamapps.uisession.statistics.SessionState;

public class UiSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final QualifiedUiSessionId sessionId;
    private String name;
    private final TeamAppsConfiguration config;
    private final ObjectMapper objectMapper;
    private final Consumer<UiSession> closeListener;
    private UiSessionListener sessionListener;
    private MessageSender messageSender;
    private final CommandBuffer commandBuffer;
    private final AtomicInteger commandIdCounter = new AtomicInteger();
    private final AtomicLong timestampOfLastMessageFromClient = new AtomicLong();
    private int lastReceivedClientMessageId;
    private boolean clientReadyToReceiveCommands = true;
    private boolean active = true;
    private int maxRequestedCommandId = 0;
    private int lastSentCommandId;
    private long requestedCommandsZeroTimestamp = -1L;
    private final Map<Integer, ResultCallbackWithCommandClass> resultCallbacksByCmdId = new ConcurrentHashMap<Integer, ResultCallbackWithCommandClass>();
    private final RunningUiSessionStats statistics;

    public UiSession(QualifiedUiSessionId sessionId, long creationTime, TeamAppsConfiguration config, ObjectMapper objectMapper, MessageSender messageSender, Consumer<UiSession> closeListener) {
        this.sessionId = sessionId;
        this.name = sessionId.toString();
        this.config = config;
        this.objectMapper = objectMapper;
        this.closeListener = closeListener;
        this.timestampOfLastMessageFromClient.set(creationTime);
        this.messageSender = messageSender;
        this.statistics = new RunningUiSessionStats(System.currentTimeMillis(), sessionId, this.name);
        this.commandBuffer = new CommandBuffer(config.getCommandBufferSize());
    }

    public void updateStats() {
        this.statistics.update(this.messageSender.getDataSent(), this.messageSender.getDataReceived());
    }

    public QualifiedUiSessionId getSessionId() {
        return this.sessionId;
    }

    public void setName(String name) {
        this.name = name;
        this.statistics.nameChanged(name);
    }

    public String getName() {
        return this.name;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.statistics.stateChanged(active ? SessionState.ACTIVE : SessionState.INACTIVE);
        this.sessionListener.onActivityStateChanged(this.sessionId, false);
    }

    public boolean isActive() {
        return this.active;
    }

    public long getTimestampOfLastMessageFromClient() {
        return this.timestampOfLastMessageFromClient.get();
    }

    public void setMessageSender(MessageSender messageSender) {
        this.messageSender = messageSender;
    }

    public void setSessionListener(UiSessionListener sessionListener) {
        this.sessionListener = sessionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendCommand(UiCommandWithResultCallback commandWithCallback) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending command ({}): {}", (Object)this.sessionId.getUiSessionId().substring(0, 8), (Object)commandWithCallback.getUiCommand().getClass().getSimpleName());
        }
        this.statistics.commandSent(commandWithCallback.getUiCommand());
        CMD cmd = this.createCMD(commandWithCallback);
        UiSession uiSession = this;
        synchronized (uiSession) {
            try {
                this.commandBuffer.addCommand(cmd);
            }
            catch (UnconsumedCommandsOverflowException e) {
                LOGGER.error("Too many unconsumed commands!", (Throwable)e);
                this.close(UiSessionClosingReason.COMMANDS_OVERFLOW);
                return -1;
            }
            this.sendAllQueuedCommandsIfPossible();
            return this.commandBuffer.getUnconsumedCommandsCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientBackPressureInfo getClientBackPressureInfo() {
        UiSession uiSession = this;
        synchronized (uiSession) {
            return new ClientBackPressureInfo(this.config.getCommandBufferSize(), this.commandBuffer.getUnconsumedCommandsCount(), this.config.getClientMinRequestedCommands(), this.config.getClientMaxRequestedCommands(), this.maxRequestedCommandId - this.lastSentCommandId, this.requestedCommandsZeroTimestamp);
        }
    }

    private CMD createCMD(UiCommandWithResultCallback commandWithCallback) {
        CMD cmd;
        try {
            int cmdId = this.commandIdCounter.incrementAndGet();
            cmd = new CMD(cmdId, this.objectMapper.writeValueAsString(commandWithCallback.getUiCommand()));
            if (commandWithCallback.getResultCallback() != null) {
                cmd.setAwaitsResponse(true);
                this.resultCallbacksByCmdId.put(cmdId, new ResultCallbackWithCommandClass(commandWithCallback.getResultCallback(), commandWithCallback.getUiCommand().getClass()));
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rewindToCommand(int commandId) {
        UiSession uiSession = this;
        synchronized (uiSession) {
            this.lastSentCommandId = commandId - 1;
            return this.commandBuffer.rewindToCommand(commandId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllQueuedCommandsIfPossible() {
        if (this.clientReadyToReceiveCommands) {
            ArrayList<CMD> cmdsToSend = new ArrayList<CMD>();
            UiSession uiSession = this;
            synchronized (uiSession) {
                while (this.clientReadyToReceiveCommands) {
                    if (this.lastSentCommandId >= this.maxRequestedCommandId) {
                        this.clientReadyToReceiveCommands = false;
                        this.requestedCommandsZeroTimestamp = System.currentTimeMillis();
                        break;
                    }
                    this.requestedCommandsZeroTimestamp = -1L;
                    CMD cmd = this.commandBuffer.consumeCommand();
                    if (cmd == null) break;
                    this.lastSentCommandId = cmd.getId();
                    cmdsToSend.add(cmd);
                }
            }
            if (!cmdsToSend.isEmpty()) {
                this.sendAsyncWithErrorHandler((AbstractServerMessage)new MULTI_CMD(cmdsToSend));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reviveConnection() {
        UiSession uiSession = this;
        synchronized (uiSession) {
            this.clientReadyToReceiveCommands = true;
            this.sendAllQueuedCommandsIfPossible();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommandRequest(int lastReceivedCommandId, int maxRequestedCommandId) {
        LOGGER.trace("UiSession.requestCommands: maxRequestedCommandId = [" + maxRequestedCommandId + "]");
        this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
        UiSession uiSession = this;
        synchronized (uiSession) {
            this.commandBuffer.purgeTillCommand(lastReceivedCommandId);
            this.maxRequestedCommandId = Math.max(maxRequestedCommandId, this.maxRequestedCommandId);
            this.reviveConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int maxRequestedCommandId) {
        this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
        UiSession uiSession = this;
        synchronized (uiSession) {
            this.maxRequestedCommandId = maxRequestedCommandId;
        }
        LOGGER.debug("INIT successful: " + this.sessionId);
        this.sendAsyncWithErrorHandler((AbstractServerMessage)new INIT_OK(this.config.getClientMinRequestedCommands(), this.config.getClientMaxRequestedCommands(), this.config.getClientEventsBufferSize(), this.config.getKeepaliveMessageIntervalMillis()));
    }

    public void handleEvent(int clientMessageId, UiEvent event) {
        this.statistics.eventReceived(event);
        this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Recieved event ({}): {}", (Object)this.sessionId.getUiSessionId().substring(0, 8), (Object)event.getUiEventType());
        }
        this.updateClientMessageId(clientMessageId);
        this.reviveConnection();
        this.sessionListener.onUiEvent(this.sessionId, event).exceptionally(e -> {
            LOGGER.error("Exception while handling ui event", e);
            this.close(UiSessionClosingReason.SERVER_SIDE_ERROR);
            return null;
        });
    }

    public void handleQuery(int clientMessageId, UiQuery query) {
        this.statistics.queryReceived(query);
        this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Recieved query ({}): {}", (Object)this.sessionId.getUiSessionId().substring(0, 8), (Object)query.getUiQueryType());
        }
        this.updateClientMessageId(clientMessageId);
        this.reviveConnection();
        this.sessionListener.onUiQuery(this.sessionId, query, result -> {
            this.sendAsyncWithErrorHandler((AbstractServerMessage)new QUERY_RESULT(clientMessageId, result));
            this.statistics.queryResultSentFor(query);
        }, exception -> {
            LOGGER.error("Exception while handling ui event", exception);
            this.close(UiSessionClosingReason.SERVER_SIDE_ERROR);
        });
    }

    public void handleCommandResult(int clientMessageId, int cmdId, Object result) {
        this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Recieved command result ({}): {}", (Object)this.sessionId.getUiSessionId().substring(0, 8), result);
        }
        this.updateClientMessageId(clientMessageId);
        this.reviveConnection();
        ResultCallbackWithCommandClass resultCallback = this.resultCallbacksByCmdId.remove(cmdId);
        if (resultCallback != null) {
            this.statistics.commandResultReceivedFor(resultCallback.commandClass);
            resultCallback.callback.accept(result);
        } else {
            LOGGER.error("Could not find result callback for CMD_RESULT! cmdId: " + cmdId);
        }
    }

    private void updateClientMessageId(int clientMessageId) {
        if (this.lastReceivedClientMessageId != -1 && clientMessageId != this.lastReceivedClientMessageId + 1) {
            LOGGER.warn("Missing event from client? Expected event id: " + this.lastReceivedClientMessageId + "1; Got: " + clientMessageId);
        }
        this.lastReceivedClientMessageId = clientMessageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinit(int lastReceivedCommandId, int maxRequestedCommandId, MessageSender messageSender) {
        this.setMessageSender(messageSender);
        if (this.rewindToCommand(lastReceivedCommandId)) {
            LOGGER.debug("REINIT successful: " + this.sessionId);
            UiSession uiSession = this;
            synchronized (uiSession) {
                this.maxRequestedCommandId = Math.max(maxRequestedCommandId, this.maxRequestedCommandId);
            }
            this.sendAsyncWithErrorHandler((AbstractServerMessage)new REINIT_OK(this.lastReceivedClientMessageId));
            this.reviveConnection();
        } else {
            LOGGER.warn("Could not reinit. Command with id " + lastReceivedCommandId + "not found in command buffer.");
            this.sendAsyncWithErrorHandler((AbstractServerMessage)new REINIT_NOK(UiSessionClosingReason.REINIT_COMMAND_ID_NOT_FOUND));
        }
    }

    public void sendAsyncWithErrorHandler(AbstractServerMessage message) {
        long sendTime = System.currentTimeMillis();
        this.messageSender.sendMessageAsynchronously(message, exception -> {
            if (this.timestampOfLastMessageFromClient.get() <= sendTime) {
                this.clientReadyToReceiveCommands = false;
            }
        });
    }

    public void handleKeepAlive() {
        this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
        this.reviveConnection();
    }

    public void ping() {
        this.sendAsyncWithErrorHandler((AbstractServerMessage)new PING());
    }

    public void close(UiSessionClosingReason reason) {
        this.messageSender.close(reason, null);
        this.statistics.stateChanged(SessionState.CLOSED);
        this.closeListener.accept(this);
        this.sessionListener.onUiSessionClosed(this.sessionId, reason);
    }

    public RunningUiSessionStats getStatistics() {
        return this.statistics;
    }

    private class ResultCallbackWithCommandClass {
        private final Consumer<Object> callback;
        private final Class<?> commandClass;

        public ResultCallbackWithCommandClass(Consumer<Object> callback, Class<?> commandClass) {
            this.callback = callback;
            this.commandClass = commandClass;
        }
    }
}

