/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.uisession.statistics;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicLong;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiQuery;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.uisession.statistics.CountStats;
import org.teamapps.uisession.statistics.ImmutableUiSessionStats;
import org.teamapps.uisession.statistics.SessionState;
import org.teamapps.uisession.statistics.SumStats;
import org.teamapps.uisession.statistics.UiSessionStats;

public class RunningUiSessionStats
implements UiSessionStats {
    private final long startTime;
    private long endTime = -1L;
    private final QualifiedUiSessionId sessionId;
    private String name;
    private SessionState state = SessionState.ACTIVE;
    private final RunningCountStats commandStats = new RunningCountStats();
    private final RunningCountStats commandResultStats = new RunningCountStats();
    private final RunningCountStats eventStats = new RunningCountStats();
    private final RunningCountStats queryStats = new RunningCountStats();
    private final RunningCountStats queryResultStats = new RunningCountStats();
    private final RunningSumStats sentDataStats = new RunningSumStats();
    private final RunningSumStats receivedDataStats = new RunningSumStats();

    public RunningUiSessionStats(long startTime, QualifiedUiSessionId sessionId, String name) {
        this.startTime = startTime;
        this.sessionId = sessionId;
        this.name = name;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public QualifiedUiSessionId getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SessionState getState() {
        return this.state;
    }

    @Override
    public CountStats getCommandStats() {
        return this.commandStats;
    }

    @Override
    public CountStats getCommandResultStats() {
        return this.commandResultStats;
    }

    @Override
    public CountStats getEventStats() {
        return this.eventStats;
    }

    @Override
    public CountStats getQueryStats() {
        return this.queryStats;
    }

    @Override
    public CountStats getQueryResultStats() {
        return this.queryResultStats;
    }

    @Override
    public SumStats getSentDataStats() {
        return this.sentDataStats;
    }

    @Override
    public SumStats getReceivedDataStats() {
        return this.receivedDataStats;
    }

    public void nameChanged(String name) {
        this.name = name;
    }

    public void commandSent(UiCommand command) {
        this.commandStats.add(command.getClass());
    }

    public void commandResultReceivedFor(Class<?> commandClass) {
        this.commandResultStats.add(commandClass);
    }

    public void eventReceived(UiEvent event) {
        this.eventStats.add(event.getClass());
    }

    public void queryReceived(UiQuery query) {
        this.queryStats.add(query.getClass());
    }

    public void queryResultSentFor(UiQuery query) {
        this.queryResultStats.add(query.getClass());
    }

    public void stateChanged(SessionState sessionState) {
        this.state = sessionState;
        if (this.state == SessionState.CLOSED) {
            this.endTime = System.currentTimeMillis();
        }
    }

    public ImmutableUiSessionStats immutableCopy() {
        return new ImmutableUiSessionStats(this.startTime, this.endTime, this.sessionId, this.name, SessionState.CLOSED, this.commandStats.toImmutable(), this.commandResultStats.toImmutable(), this.eventStats.toImmutable(), this.queryStats.toImmutable(), this.queryResultStats.toImmutable(), this.sentDataStats.toImmutable(), this.receivedDataStats.toImmutable());
    }

    public void update(long totalDataSent, long totalDataReceived) {
        this.commandStats.flush();
        this.commandResultStats.flush();
        this.eventStats.flush();
        this.queryStats.flush();
        this.queryResultStats.flush();
        this.sentDataStats.update(totalDataSent);
        this.receivedDataStats.update(totalDataReceived);
    }

    private static class RunningSumStats
    implements SumStats {
        private long total;
        private final Deque<Long> sum10sChunks = new ArrayDeque<Long>(6);
        private long sumLast10Seconds;
        private long sumLastMinute;

        private RunningSumStats() {
        }

        public void update(long total) {
            while (this.sum10sChunks.size() >= 6) {
                this.sum10sChunks.removeFirst();
            }
            long size10s = total - this.total;
            this.sum10sChunks.addLast(size10s);
            this.sumLastMinute = this.sum10sChunks.stream().mapToLong(value -> value).sum();
            this.sumLast10Seconds = size10s;
            this.total = total;
        }

        @Override
        public long getSum() {
            return this.total;
        }

        @Override
        public long getSumLastMinute() {
            return this.sumLastMinute;
        }

        @Override
        public long getSumLast10Seconds() {
            return this.sumLast10Seconds;
        }

        public ImmutableUiSessionStats.ImmutableSumStats toImmutable() {
            return new ImmutableUiSessionStats.ImmutableSumStats(this.total, this.sumLastMinute, this.sumLast10Seconds);
        }
    }

    private static class RunningCountStats
    implements CountStats {
        private final AtomicLong count = new AtomicLong();
        private final AtomicLong currentChunkCount = new AtomicLong();
        private final Deque<Long> count10sChunks = new ArrayDeque<Long>(6);
        private long countLast10Seconds;
        private long countLastMinute;
        private final Object2LongMap<Class<?>> countByClass = new Object2LongOpenHashMap();

        private RunningCountStats() {
        }

        public void add(Class<?> aClass) {
            this.count.incrementAndGet();
            this.currentChunkCount.incrementAndGet();
            this.countByClass.computeLong(aClass, (clazz, count) -> count != null ? count + 1L : 1L);
        }

        public void flush() {
            while (this.count10sChunks.size() >= 6) {
                this.count10sChunks.removeFirst();
            }
            long currentChunkCount = this.currentChunkCount.getAndSet(0L);
            this.count10sChunks.addLast(currentChunkCount);
            this.countLastMinute = this.count10sChunks.stream().mapToLong(value -> value).sum();
            this.countLast10Seconds = currentChunkCount;
        }

        @Override
        public long getCount() {
            return this.count.get();
        }

        @Override
        public long getCountLastMinute() {
            return this.countLastMinute;
        }

        @Override
        public long getCountLast10Seconds() {
            return this.countLast10Seconds;
        }

        @Override
        public Object2LongMap<Class<?>> getCountByClass() {
            return this.countByClass;
        }

        public ImmutableUiSessionStats.ImmutableCountStats toImmutable() {
            return new ImmutableUiSessionStats.ImmutableCountStats(this.count.get(), this.getCountLastMinute(), this.getCountLast10Seconds(), this.countByClass);
        }
    }
}

