/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.ux.servlet.WebSocketCommunicationEndpoint;

public class TeamAppsWebSocketMetrics
implements MeterBinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final WebSocketCommunicationEndpoint webSocketCommunicationEndpoint;

    public TeamAppsWebSocketMetrics(WebSocketCommunicationEndpoint webSocketCommunicationEndpoint) {
        this.webSocketCommunicationEndpoint = webSocketCommunicationEndpoint;
    }

    public void bindTo(MeterRegistry registry) {
        Gauge.builder((String)"teamapps.websocket.chars.sent", (Object)((Object)this.webSocketCommunicationEndpoint), WebSocketCommunicationEndpoint::getTotalSendCount).description("Total number of characters (uncompressed) sent through websocket to all clients.").register(registry);
        Gauge.builder((String)"teamapps.websocket.chars.received", (Object)((Object)this.webSocketCommunicationEndpoint), WebSocketCommunicationEndpoint::getTotalReceiveCount).description("Total number of characters (uncompressed) received through websocket to all clients.").register(registry);
    }
}

