/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.assembler;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.common.format.Color;
import org.teamapps.icons.Icon;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.ResponsiveApplicationToolbar;
import org.teamapps.ux.application.assembler.ApplicationAssembler;
import org.teamapps.ux.application.assembler.ButtonData;
import org.teamapps.ux.application.assembler.ButtonDataType;
import org.teamapps.ux.application.assembler.MobileApplicationNavigationController;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.application.view.ViewSize;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.animation.PageTransition;
import org.teamapps.ux.component.calendar.Calendar;
import org.teamapps.ux.component.charting.forcelayout.ForceLayoutGraph;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemView2;
import org.teamapps.ux.component.itemview.ItemView;
import org.teamapps.ux.component.itemview.SimpleItem;
import org.teamapps.ux.component.itemview.SimpleItemGroup;
import org.teamapps.ux.component.itemview.SimpleItemView;
import org.teamapps.ux.component.map.MapView;
import org.teamapps.ux.component.mobile.MobileLayout;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.progress.MultiProgressDisplay;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.timegraph.TimeGraph;
import org.teamapps.ux.component.toolbar.AbstractToolContainer;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.tree.Tree;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;

public class TopNavigationMobileApplicationAssembler
implements ApplicationAssembler {
    private static final int PAGE_TRANSITION_ANIMATION_DURATION = 300;
    private Component applicationLauncher;
    private VerticalLayout verticalLayout;
    private Toolbar navigationToolbar;
    private final MobileLayout mobileLayout;
    private AbstractToolContainer mainToolbar;
    private MobileApplicationNavigationController navigationController;
    private SimpleItemView<Void> viewsItemView;
    private final List<View> applicationViews = new ArrayList<View>();
    private List<View> perspectiveViews = new ArrayList<View>();
    private final ToolbarButtonGroup centerGroup;
    private final ToolbarButtonGroup leftGroup;
    private final ToolbarButtonGroup rightGroup;
    private final ToolbarButton navigationToolbarMenuButton;
    private View activeView;

    public TopNavigationMobileApplicationAssembler(MobileApplicationNavigationController navigationController) {
        this.navigationController = navigationController;
        this.verticalLayout = new VerticalLayout();
        this.mobileLayout = new MobileLayout();
        this.viewsItemView = new SimpleItemView();
        this.navigationToolbar = new Toolbar();
        this.applicationLauncher = navigationController.getApplicationLauncher();
        this.verticalLayout.addComponentAutoSize(this.navigationToolbar);
        this.verticalLayout.addComponentFillRemaining(this.mobileLayout);
        this.navigationToolbar.setBackgroundColor((Color)Color.WHITE.withAlpha(0.6f));
        this.leftGroup = this.navigationToolbar.addButtonGroup(new ToolbarButtonGroup());
        ButtonData backButtonData = navigationController.getButtonData(ButtonDataType.BACK);
        ToolbarButton backButton = new ToolbarButton(BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, new BaseTemplateRecord(backButtonData.getIcon(), backButtonData.getTitle()));
        this.leftGroup.addButton(backButton);
        this.leftGroup.setShowGroupSeparator(false);
        backButton.onClick.addListener(() -> {
            if (this.activeView == null && navigationController.isBackOperationAvailable()) {
                navigationController.fireBackOperation();
            } else {
                this.goBack();
            }
        });
        this.centerGroup = this.navigationToolbar.addButtonGroup(new ToolbarButtonGroup());
        this.centerGroup.addButton(new ToolbarButton(BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, new BaseTemplateRecord("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;")));
        this.centerGroup.setShowGroupSeparator(false);
        ButtonData viewButtonData = navigationController.getButtonData(ButtonDataType.VIEWS);
        ToolbarButton viewsButton = new ToolbarButton(BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, new BaseTemplateRecord(viewButtonData.getIcon(), viewButtonData.getTitle()));
        viewsButton.setDropDownComponent(this.viewsItemView);
        viewsButton.setDroDownPanelWidth(450);
        this.centerGroup.addButton(viewsButton);
        this.rightGroup = this.navigationToolbar.addButtonGroup(new ToolbarButtonGroup());
        this.rightGroup.setRightSide(true);
        this.rightGroup.setShowGroupSeparator(false);
        ButtonData menuButtonData = navigationController.getButtonData(ButtonDataType.MENU);
        this.navigationToolbarMenuButton = new ToolbarButton(BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, new BaseTemplateRecord(menuButtonData.getIcon(), menuButtonData.getTitle()));
        this.rightGroup.addButton(this.navigationToolbarMenuButton);
        this.setNavigationToolbarVisible(false);
    }

    private void setNavigationToolbarVisible(boolean visible) {
        this.navigationToolbar.setVisible(visible);
        this.leftGroup.setVisible(visible);
        this.centerGroup.setVisible(visible);
        this.rightGroup.setVisible(visible);
    }

    public void goBack() {
        int i;
        View view = null;
        for (i = 0; i < this.perspectiveViews.size(); ++i) {
            if (!this.perspectiveViews.get(i).equals(this.activeView)) continue;
            if (i > 0) {
                view = this.perspectiveViews.get(i - 1);
                break;
            }
            if (this.applicationViews.isEmpty()) break;
            view = this.applicationViews.get(this.applicationViews.size() - 1);
            break;
        }
        if (view == null) {
            for (i = 0; i < this.applicationViews.size(); ++i) {
                if (!this.applicationViews.get(i).equals(this.activeView)) continue;
                if (i <= 0) break;
                view = this.applicationViews.get(i - 1);
                break;
            }
        }
        this.activeView = view;
        if (this.activeView == null) {
            this.setNavigationToolbarVisible(false);
            this.mobileLayout.setContent(this.applicationLauncher, PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT, 300);
        } else {
            this.setNavigationToolbarVisible(true);
            this.mobileLayout.setContent(this.activeView.getPanel(), PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT, 300);
        }
    }

    public void showView(View view) {
        if (view == null) {
            this.activeView = view;
            this.setNavigationToolbarVisible(false);
            this.mobileLayout.setContent(this.applicationLauncher, PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT, 300);
            return;
        }
        if (view.equals(this.activeView)) {
            return;
        }
        ArrayList<View> views = new ArrayList<View>(this.applicationViews);
        views.addAll(this.perspectiveViews);
        int lastPos = -1;
        int newPos = 0;
        for (int i = 0; i < views.size(); ++i) {
            if (this.activeView != null && this.activeView.equals(views.get(i))) {
                lastPos = i;
            }
            if (!view.equals(views.get(i))) continue;
            newPos = i;
        }
        if (newPos > lastPos) {
            this.mobileLayout.setContent(view.getPanel(), PageTransition.MOVE_TO_LEFT_VS_MOVE_FROM_RIGHT, 300);
        } else {
            this.mobileLayout.setContent(view.getPanel(), PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT, 300);
        }
        this.activeView = view;
    }

    public void showInitialView() {
        View view = null;
        if (!this.applicationViews.isEmpty()) {
            view = this.applicationViews.get(0);
        } else if (!this.perspectiveViews.isEmpty()) {
            view = this.perspectiveViews.get(0);
        }
        if (view != null) {
            this.mobileLayout.setContent(view.getPanel(), PageTransition.MOVE_TO_LEFT_VS_MOVE_FROM_RIGHT, 300);
            this.activeView = view;
        }
    }

    @Override
    public void setWorkSpaceToolbar(ResponsiveApplicationToolbar toolbar) {
        this.mainToolbar = toolbar.getToolbar();
        this.navigationToolbarMenuButton.setDropDownComponent(this.mainToolbar);
        this.mainToolbar.onButtonClick.addListener(() -> {});
    }

    @Override
    public Component createApplication(ResponsiveApplication application) {
        return this.verticalLayout;
    }

    @Override
    public MultiProgressDisplay getMultiProgressDisplay() {
        return null;
    }

    @Override
    public void handleApplicationViewAdded(ResponsiveApplication application, View view) {
        this.applicationViews.add(view);
    }

    @Override
    public void handleApplicationViewRemoved(ResponsiveApplication application, View view) {
        this.applicationViews.remove(view);
    }

    @Override
    public void handlePerspectiveChange(ResponsiveApplication application, Perspective perspective, Perspective previousPerspective, List<View> activeViews, List<View> addedViews, List<View> removedViews) {
        addedViews.forEach(view -> this.mobileLayout.preloadView(view.getPanel()));
        this.perspectiveViews = activeViews;
        this.viewsItemView.removeAllGroups();
        ButtonData appGroupData = this.navigationController.getButtonData(ButtonDataType.APPLICATION_GROUP);
        SimpleItemGroup<Void> appGroup = this.viewsItemView.addSingleColumnGroup(appGroupData.getIcon(), appGroupData.getTitle());
        appGroup.setItemTemplate(BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES);
        ButtonData appLauncherData = this.navigationController.getButtonData(ButtonDataType.APPLICATION_LAUNCHER);
        appGroup.addItem((Icon)appLauncherData.getIcon(), (String)appLauncherData.getTitle(), (String)appLauncherData.getDescription()).onClick.addListener(() -> this.showView(null));
        this.applicationViews.forEach(view -> appGroup.addItem(this.createViewButton((View)view)));
        ButtonData viewGroupData = this.navigationController.getButtonData(ButtonDataType.VIEW_GROUP);
        SimpleItemGroup<Void> viewGroup = this.viewsItemView.addSingleColumnGroup(viewGroupData.getIcon(), viewGroupData.getTitle());
        viewGroup.setItemTemplate(BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES);
        this.perspectiveViews.forEach(view -> viewGroup.addItem(this.createViewButton((View)view)));
        if (!this.perspectiveViews.isEmpty()) {
            View view2;
            this.activeView = view2 = perspective.getFocusedView() != null ? perspective.getFocusedView() : this.perspectiveViews.get(0);
            this.mobileLayout.setContent(view2.getPanel(), PageTransition.MOVE_TO_LEFT_VS_MOVE_FROM_RIGHT, 300);
            this.setNavigationToolbarVisible(true);
        }
    }

    private SimpleItem<Void> createViewButton(View view) {
        ButtonData buttonData = null;
        Panel panel = view.getPanel();
        buttonData = this.navigationController.getApplicationMenuView().equals(view) ? this.navigationController.getButtonData(ButtonDataType.APPLICATION_MENU) : this.navigationController.getButtonData(this.getViewType(panel.getContent()));
        Icon icon = buttonData != null ? buttonData.getIcon() : panel.getIcon();
        String title = buttonData != null ? buttonData.getTitle() : panel.getTitle();
        String description = buttonData != null ? panel.getTitle() : null;
        SimpleItem<Void> item = new SimpleItem<Void>(icon, title, description);
        item.onClick.addListener(() -> this.showView(view));
        return item;
    }

    private ButtonDataType getViewType(Component content) {
        if (content == null) {
            return null;
        }
        if (content instanceof Table) {
            return ButtonDataType.TABLE;
        }
        if (content instanceof ItemView || content instanceof InfiniteItemView2) {
            return ButtonDataType.LIST;
        }
        if (content instanceof ResponsiveForm) {
            return ButtonDataType.FORM;
        }
        if (content instanceof Calendar) {
            return ButtonDataType.CALENDAR;
        }
        if (content instanceof TimeGraph) {
            return ButtonDataType.TIME_GRAPH;
        }
        if (content instanceof Tree) {
            return ButtonDataType.TREE;
        }
        if (content instanceof MapView) {
            return ButtonDataType.MAP;
        }
        if (content instanceof ForceLayoutGraph) {
            return ButtonDataType.NETWORK_GRAPH;
        }
        return null;
    }

    @Override
    public void handleLayoutChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, LayoutItemDefinition layout) {
    }

    @Override
    public void handleViewAdded(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view) {
        if (isActivePerspective) {
            this.mobileLayout.preloadView(view.getPanel());
            this.perspectiveViews.add(view);
        }
    }

    @Override
    public void handleViewRemoved(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view) {
        if (isActivePerspective) {
            this.perspectiveViews.remove(view);
        }
    }

    @Override
    public void handleViewVisibilityChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, boolean visible) {
        if (isActivePerspective) {
            // empty if block
        }
    }

    @Override
    public void handleViewFocusRequest(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, boolean ensureVisible) {
        if (isActivePerspective) {
            this.showView(view);
        }
    }

    @Override
    public void handleViewSizeChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, ViewSize viewSize) {
    }

    @Override
    public void handleViewTabTitleChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, String title) {
    }

    @Override
    public void handleViewLayoutPositionChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, String position) {
    }

    @Override
    public void handleApplicationToolbarButtonGroupAdded(ResponsiveApplication application, ToolbarButtonGroup buttonGroup) {
    }
}

