/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.infiniteitemview;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.dto.UiInfiniteItemView;
import org.teamapps.dto.UiInfiniteItemViewDataRequest;
import org.teamapps.event.Event;
import org.teamapps.ux.cache.record.legacy.CacheManipulationHandle;
import org.teamapps.ux.cache.record.legacy.ClientRecordCache;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemViewModel;
import org.teamapps.ux.component.infiniteitemview.ItemClickedEventData;
import org.teamapps.ux.component.infiniteitemview.ListInfiniteItemViewModel;
import org.teamapps.ux.component.infiniteitemview.RecordsAddedEvent;
import org.teamapps.ux.component.infiniteitemview.RecordsChangedEvent;
import org.teamapps.ux.component.infiniteitemview.RecordsRemovedEvent;
import org.teamapps.ux.component.itemview.ItemViewRowJustification;
import org.teamapps.ux.component.itemview.ItemViewVerticalItemAlignment;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

@Deprecated
public class InfiniteItemView<RECORD>
extends AbstractComponent {
    public final Event<ItemClickedEventData<RECORD>> onItemClicked = new Event();
    private int numberOfInitialRecords = 100;
    private Template itemTemplate;
    private float itemWidth;
    private int rowHeight;
    private int horizontalItemMargin = 0;
    boolean autoHeight = false;
    private ItemViewRowJustification itemJustification = ItemViewRowJustification.LEFT;
    private ItemViewVerticalItemAlignment verticalItemAlignment = ItemViewVerticalItemAlignment.STRETCH;
    private InfiniteItemViewModel<RECORD> model = new ListInfiniteItemViewModel(Collections.emptyList());
    private PropertyProvider<RECORD> itemPropertyProvider = new BeanPropertyExtractor();
    protected final ClientRecordCache<RECORD, UiIdentifiableClientRecord> itemCache;
    private final Consumer<Void> modelOnAllDataChangedListener = aVoid -> this.refresh();
    private final Consumer<RecordsAddedEvent<RECORD>> modelOnRecordAddedListener = x -> this.refresh();
    private final Consumer<RecordsChangedEvent<RECORD>> modelOnRecordChangedListener = x -> this.refresh();
    private final Consumer<RecordsRemovedEvent<RECORD>> modelOnRecordDeletedListener = x -> this.refresh();
    private Function<RECORD, Component> contextMenuProvider = null;
    private int lastSeenContextMenuRequestId;
    private int displayedRangeStart = 0;
    private int displayedRangeLength = this.numberOfInitialRecords;
    private List<Integer> viewportDisplayedRecordClientIds = Collections.emptyList();

    public InfiniteItemView(Template itemTemplate, float itemWidth, int rowHeight) {
        this.itemTemplate = itemTemplate;
        this.itemWidth = itemWidth;
        this.rowHeight = rowHeight;
        this.itemCache = new ClientRecordCache<Object, UiIdentifiableClientRecord>(this::createUiIdentifiableClientRecord);
        this.itemCache.setMaxCapacity(1000);
        this.itemCache.setPurgeDecider((record, clientId) -> !this.viewportDisplayedRecordClientIds.contains(clientId));
        this.itemCache.setPurgeListener(operationHandle -> {
            if (this.isRendered()) {
                List removedItemIds = (List)operationHandle.getAndClearResult();
                this.getSessionContext().queueCommand(new UiInfiniteItemView.RemoveDataCommand(this.getId(), removedItemIds), aVoid -> operationHandle.commit());
            } else {
                operationHandle.commit();
            }
        });
    }

    public InfiniteItemView(float itemWidth, int itemHeight) {
        this(BaseTemplate.ITEM_VIEW_ITEM, itemWidth, itemHeight);
    }

    public InfiniteItemView() {
        this(BaseTemplate.ITEM_VIEW_ITEM, 300.0f, 300);
    }

    @Override
    public UiComponent createUiComponent() {
        UiInfiniteItemView ui = new UiInfiniteItemView(this.itemTemplate.createUiTemplate(), this.rowHeight);
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        int recordCount = this.model.getCount();
        CacheManipulationHandle<List<UiIdentifiableClientRecord>> cacheResponse = this.itemCache.replaceRecords(this.model.getRecords(0, Math.min(recordCount, this.numberOfInitialRecords)));
        cacheResponse.commit();
        ui.setData(cacheResponse.getAndClearResult());
        ui.setTotalNumberOfRecords(recordCount);
        ui.setItemWidth(this.itemWidth);
        ui.setHorizontalItemMargin(this.horizontalItemMargin);
        ui.setItemJustification(this.itemJustification.toUiItemJustification());
        ui.setVerticalItemAlignment(this.verticalItemAlignment.toUiItemJustification());
        ui.setAutoHeight(this.autoHeight);
        ui.setContextMenuEnabled(this.contextMenuProvider != null);
        return ui;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_INFINITE_ITEM_VIEW_DISPLAYED_RANGE_CHANGED: {
                UiInfiniteItemView.DisplayedRangeChangedEvent rangeChangedEvent = (UiInfiniteItemView.DisplayedRangeChangedEvent)event;
                this.viewportDisplayedRecordClientIds = rangeChangedEvent.getDisplayedRecordIds();
                this.displayedRangeStart = rangeChangedEvent.getStartIndex();
                this.displayedRangeLength = rangeChangedEvent.getLength();
                if (rangeChangedEvent.getDataRequest() == null) break;
                UiInfiniteItemViewDataRequest dataRequest = rangeChangedEvent.getDataRequest();
                int startIndex = dataRequest.getStartIndex();
                int length = dataRequest.getLength();
                this.sendRecords(startIndex, length, false);
                break;
            }
            case UI_INFINITE_ITEM_VIEW_ITEM_CLICKED: {
                UiInfiniteItemView.ItemClickedEvent itemClickedEvent = (UiInfiniteItemView.ItemClickedEvent)event;
                RECORD record = this.itemCache.getRecordByClientId(itemClickedEvent.getRecordId());
                if (record == null) break;
                this.onItemClicked.fire(new ItemClickedEventData<RECORD>(record, itemClickedEvent.getIsDoubleClick(), itemClickedEvent.getIsRightMouseButton()));
                break;
            }
            case UI_INFINITE_ITEM_VIEW_CONTEXT_MENU_REQUESTED: {
                UiInfiniteItemView.ContextMenuRequestedEvent e = (UiInfiniteItemView.ContextMenuRequestedEvent)event;
                this.lastSeenContextMenuRequestId = e.getRequestId();
                RECORD record = this.itemCache.getRecordByClientId(e.getRecordId());
                if (record != null && this.contextMenuProvider != null) {
                    Component contextMenuContent = this.contextMenuProvider.apply(record);
                    if (contextMenuContent != null) {
                        this.queueCommandIfRendered(() -> new UiInfiniteItemView.SetContextMenuContentCommand(this.getId(), e.getRequestId(), contextMenuContent.createUiReference()));
                        break;
                    }
                    this.queueCommandIfRendered(() -> new UiInfiniteItemView.CloseContextMenuCommand(this.getId(), e.getRequestId()));
                    break;
                }
                this.closeContextMenu();
                break;
            }
        }
    }

    public boolean isAutoHeight() {
        return this.autoHeight;
    }

    public void setAutoHeight(boolean autoHeight) {
        this.autoHeight = autoHeight;
    }

    private UiIdentifiableClientRecord createUiIdentifiableClientRecord(RECORD record) {
        UiIdentifiableClientRecord clientRecord = new UiIdentifiableClientRecord();
        clientRecord.setValues(this.itemPropertyProvider.getValues(record, this.itemTemplate.getPropertyNames()));
        return clientRecord;
    }

    public int getNumberOfInitialRecords() {
        return this.numberOfInitialRecords;
    }

    public InfiniteItemView<RECORD> setNumberOfInitialRecords(int numberOfInitialRecords) {
        this.numberOfInitialRecords = numberOfInitialRecords;
        return this;
    }

    public Template getItemTemplate() {
        return this.itemTemplate;
    }

    public InfiniteItemView<RECORD> setItemTemplate(Template itemTemplate) {
        this.itemTemplate = itemTemplate;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView.SetItemTemplateCommand(this.getId(), itemTemplate.createUiTemplate()));
        return this;
    }

    public float getItemWidth() {
        return this.itemWidth;
    }

    public InfiniteItemView<RECORD> setItemWidth(float itemWidth) {
        this.itemWidth = itemWidth;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView.SetItemWidthCommand(this.getId(), itemWidth));
        return this;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
        this.reRenderIfRendered();
    }

    public ItemViewVerticalItemAlignment getVerticalItemAlignment() {
        return this.verticalItemAlignment;
    }

    public void setVerticalItemAlignment(ItemViewVerticalItemAlignment verticalItemAlignment) {
        this.verticalItemAlignment = verticalItemAlignment;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView.SetVerticalItemAlignmentCommand(this.getId(), verticalItemAlignment.toUiItemJustification()));
    }

    public int getHorizontalItemMargin() {
        return this.horizontalItemMargin;
    }

    public InfiniteItemView<RECORD> setHorizontalItemMargin(int horizontalItemMargin) {
        this.horizontalItemMargin = horizontalItemMargin;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView.SetHorizontalItemMarginCommand(this.getId(), horizontalItemMargin));
        return this;
    }

    public ItemViewRowJustification getItemJustification() {
        return this.itemJustification;
    }

    public InfiniteItemView<RECORD> setItemJustification(ItemViewRowJustification itemJustification) {
        this.itemJustification = itemJustification;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView.SetItemJustificationCommand(this.getId(), itemJustification.toUiItemJustification()));
        return this;
    }

    public InfiniteItemViewModel<RECORD> getModel() {
        return this.model;
    }

    public PropertyProvider<RECORD> getItemPropertyProvider() {
        return this.itemPropertyProvider;
    }

    public void setItemPropertyProvider(PropertyProvider<RECORD> propertyProvider) {
        this.itemPropertyProvider = propertyProvider;
    }

    public void setItemPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.setItemPropertyProvider(propertyExtractor);
    }

    public InfiniteItemView<RECORD> setModel(InfiniteItemViewModel<RECORD> model) {
        this.unregisterModelListeners();
        this.model = model;
        this.refresh();
        model.onAllDataChanged().addListener(this.modelOnAllDataChangedListener);
        model.onRecordsAdded().addListener(this.modelOnRecordAddedListener);
        model.onRecordsChanged().addListener(this.modelOnRecordChangedListener);
        model.onRecordsRemoved().addListener(this.modelOnRecordDeletedListener);
        return this;
    }

    private void unregisterModelListeners() {
        this.model.onAllDataChanged().removeListener(this.modelOnAllDataChangedListener);
        this.model.onRecordsAdded().removeListener(this.modelOnRecordAddedListener);
        this.model.onRecordsChanged().removeListener(this.modelOnRecordChangedListener);
        this.model.onRecordsRemoved().removeListener(this.modelOnRecordDeletedListener);
    }

    public void refresh() {
        this.sendRecords(this.displayedRangeStart, this.displayedRangeLength, true);
    }

    protected void sendRecords(int startIndex, int length, boolean clear) {
        if (this.isRendered()) {
            int totalCount = this.model.getCount();
            List records = this.model.getRecords(startIndex, Math.max(0, Math.min(totalCount - startIndex, length)));
            CacheManipulationHandle<List<UiIdentifiableClientRecord>> cacheResponse = clear ? this.itemCache.replaceRecords(records) : this.itemCache.addRecords(records);
            this.getSessionContext().queueCommand(new UiInfiniteItemView.AddDataCommand(this.getId(), startIndex, cacheResponse.getAndClearResult(), totalCount, clear), aVoid -> cacheResponse.commit());
        }
    }

    public void setMaxCacheCapacity(int maxCapacity) {
        this.itemCache.setMaxCapacity(maxCapacity);
    }

    public Function<RECORD, Component> getContextMenuProvider() {
        return this.contextMenuProvider;
    }

    public void setContextMenuProvider(Function<RECORD, Component> contextMenuProvider) {
        this.contextMenuProvider = contextMenuProvider;
    }

    public void closeContextMenu() {
        this.queueCommandIfRendered(() -> new UiInfiniteItemView.CloseContextMenuCommand(this.getId(), this.lastSeenContextMenuRequestId));
    }
}

