/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.media;

import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiMediaTrackGraph;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.media.MediaTrackData;

public class MediaTrackGraph
extends AbstractComponent {
    public Event<TimeSelection> onTimeSelection = new Event();
    private MediaTrackData data;

    public MediaTrackGraph(MediaTrackData data) {
        this.data = data;
    }

    @Override
    public UiComponent createUiComponent() {
        UiMediaTrackGraph uiMediaTrackGraph = new UiMediaTrackGraph();
        this.mapAbstractUiComponentProperties((UiComponent)uiMediaTrackGraph);
        uiMediaTrackGraph.setTrackCount(this.data.getTrackCount());
        uiMediaTrackGraph.setTrackData(this.data.getTrackData());
        uiMediaTrackGraph.setMarkers(this.data.getMarkers());
        return uiMediaTrackGraph;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_MEDIA_TRACK_GRAPH_HANDLE_TIME_SELECTION: {
                UiMediaTrackGraph.HandleTimeSelectionEvent timeSelectionEvent = (UiMediaTrackGraph.HandleTimeSelectionEvent)event;
                long start = timeSelectionEvent.getStart();
                long end = timeSelectionEvent.getEnd();
                this.onTimeSelection.fire(new TimeSelection(start, end));
            }
        }
    }

    public void setCursorPosition(long time) {
        this.queueCommandIfRendered(() -> new UiMediaTrackGraph.SetCursorPositionCommand(this.getId(), time));
    }

    public static class TimeSelection {
        public long start;
        public long end;

        public TimeSelection(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }
}

