/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class DownloadHttpHeaderFilter
implements Filter {
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String downloadFileName = req.getParameter("teamapps-download-filename");
        if (downloadFileName != null) {
            HttpServletResponse response = (HttpServletResponse)res;
            response.setHeader("Content-Disposition", "attachment; filename=\"" + downloadFileName + "\"");
            chain.doFilter(req, (ServletResponse)new HttpServletResponseWrapper(response){

                public void setHeader(String name, String value) {
                    if (!name.toLowerCase().equals("content-disposition")) {
                        super.setHeader(name, value);
                    }
                }

                public void addHeader(String name, String value) {
                    if (!name.toLowerCase().equals("content-disposition")) {
                        super.addHeader(name, value);
                    }
                }
            });
        } else {
            chain.doFilter(req, res);
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

