/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.cache.record;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.ux.cache.record.ItemRange;
import org.teamapps.ux.cache.record.RecordAndClientRecord;

public class RenderedRecordsCache<RECORD> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<RECORD, UiIdentifiableClientRecord> uiRecordsByRecord = new HashMap<RECORD, UiIdentifiableClientRecord>();
    private final List<RecordAndClientRecord<RECORD>> recordPairs = new ArrayList<RecordAndClientRecord<RECORD>>();
    private int startIndex = 0;

    public UiIdentifiableClientRecord getUiRecord(RECORD record) {
        return this.uiRecordsByRecord.get(record);
    }

    public int getIndex(RECORD record) {
        int index = IntStream.range(0, this.recordPairs.size()).filter(i -> record.equals(this.recordPairs.get(i).getRecord())).findFirst().orElse(-1);
        if (index >= 0) {
            return this.startIndex + index;
        }
        return -1;
    }

    public List<RECORD> getRecords() {
        return this.recordPairs.stream().map(RecordAndClientRecord::getRecord).collect(Collectors.toList());
    }

    public RECORD getRecord(int uiRecordId) {
        return this.recordPairs.stream().filter(rr -> rr.getUiRecord().getId() == uiRecordId).map(RecordAndClientRecord::getRecord).findFirst().orElse(null);
    }

    public RECORD getRecordByIndex(int index) {
        return this.recordPairs.get(index - this.startIndex).getRecord();
    }

    public List<RECORD> getRecords(List<Integer> uiRecordIds) {
        HashSet<Integer> recordIdsSet = new HashSet<Integer>(uiRecordIds);
        return this.recordPairs.stream().filter(rr -> recordIdsSet.contains(rr.getUiRecord().getId())).map(RecordAndClientRecord::getRecord).collect(Collectors.toList());
    }

    public List<Integer> getUiRecordIds() {
        return this.recordPairs.stream().map(rr -> rr.getUiRecord().getId()).collect(Collectors.toList());
    }

    public List<Integer> getUiRecordIds(List<RECORD> records) {
        HashSet recordsAsSet = new HashSet(records);
        return this.recordPairs.stream().filter(rp -> recordsAsSet.contains(rp.getRecord())).map(rr -> rr.getUiRecord().getId()).collect(Collectors.toList());
    }

    public void addNoShift(int startIndex, List<RecordAndClientRecord<RECORD>> newClientRecordPairs) {
        LOGGER.debug("inserting at {}: {}", (Object)startIndex, (Object)newClientRecordPairs.size());
        if (newClientRecordPairs.size() == 0) {
            return;
        }
        if (this.recordPairs.size() == 0) {
            this.startIndex = startIndex;
        }
        if (startIndex + newClientRecordPairs.size() < this.startIndex || startIndex > this.startIndex + this.recordPairs.size()) {
            String errorMessage = String.format("Cannot addNoShift unattached records! %d, %d, %d, %d", startIndex, newClientRecordPairs.size(), this.startIndex, this.recordPairs.size());
            LOGGER.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        int listInsertIndex = Math.max(0, startIndex - this.startIndex);
        if (newClientRecordPairs.stream().anyMatch(rp -> this.uiRecordsByRecord.containsKey(rp.getRecord()))) {
            throw new IllegalArgumentException("List components MUST NOT contains the same item several times!");
        }
        this.recordPairs.addAll(listInsertIndex, newClientRecordPairs);
        for (RecordAndClientRecord<RECORD> rr : newClientRecordPairs) {
            this.uiRecordsByRecord.put(rr.getRecord(), rr.getUiRecord());
        }
        this.startIndex = Math.min(this.startIndex, startIndex);
    }

    public void insertShifting(int startIndex, List<RecordAndClientRecord<RECORD>> newClientRecordPairs) {
        if (startIndex < this.startIndex || startIndex > this.startIndex + this.recordPairs.size()) {
            String errorMessage = String.format("Cannot insertShifting unattached records! %d, %d, %d, %d", startIndex, newClientRecordPairs.size(), this.startIndex, this.recordPairs.size());
            LOGGER.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        int listInsertIndex = startIndex - this.startIndex;
        if (newClientRecordPairs.stream().anyMatch(rp -> this.uiRecordsByRecord.containsKey(rp.getRecord()))) {
            throw new IllegalArgumentException("List components MUST NOT contains the same item several times! ");
        }
        this.recordPairs.addAll(listInsertIndex, newClientRecordPairs);
        for (RecordAndClientRecord<RECORD> rr : newClientRecordPairs) {
            this.uiRecordsByRecord.put(rr.getRecord(), rr.getUiRecord());
        }
    }

    public void removeNoShift(int startIndex, int endIndex) {
        int length = endIndex - startIndex;
        int listStartIndex = startIndex - this.startIndex;
        int listEndIndex = listStartIndex + Math.min(length, this.recordPairs.size());
        this.removeNoShiftInternal(listStartIndex, listEndIndex);
    }

    public void removeBeforeNoShift(int index) {
        if (index > this.startIndex) {
            this.removeNoShiftInternal(0, Math.min(index - this.startIndex, this.recordPairs.size()));
            this.startIndex = index;
        }
    }

    public void removeAfterNoShift(int index) {
        if (index < this.startIndex + this.recordPairs.size()) {
            this.removeNoShiftInternal(Math.max(0, index - this.startIndex), this.recordPairs.size());
        }
    }

    private void removeNoShiftInternal(int startIndex, int endIndex) {
        List<RecordAndClientRecord<RECORD>> recordsToBeRemoved = this.recordPairs.subList(startIndex, endIndex);
        for (RecordAndClientRecord<RECORD> rr : recordsToBeRemoved) {
            this.uiRecordsByRecord.remove(rr.getRecord());
        }
        recordsToBeRemoved.clear();
    }

    public void clear() {
        this.startIndex = 0;
        this.uiRecordsByRecord.clear();
        this.recordPairs.clear();
    }

    public int size() {
        return this.recordPairs.size();
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.startIndex + this.recordPairs.size();
    }

    public ItemRange getRange() {
        return ItemRange.startLength(this.startIndex, this.recordPairs.size());
    }
}

