/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet;

import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.websocket.Extension;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.core.TeamAppsCore;
import org.teamapps.icons.IconProvider;
import org.teamapps.server.SessionResourceProvider;
import org.teamapps.ux.resource.IconResourceProvider;
import org.teamapps.ux.resource.ResourceProviderServlet;
import org.teamapps.ux.servlet.DownloadHttpHeaderFilter;
import org.teamapps.ux.servlet.IndexHtmlHeaderFilter;
import org.teamapps.ux.servlet.LeaveBeaconServlet;
import org.teamapps.ux.servlet.ServletRequestListener;
import org.teamapps.ux.servlet.UploadServlet;
import org.teamapps.ux.servlet.WebSocketCommunicationEndpoint;
import org.teamapps.ux.servlet.WebSocketServerEndpointConfigurator;

public class TeamAppsServletContextListener
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TeamAppsServletContextListener.class);
    private final TeamAppsCore teamAppsCore;

    public TeamAppsServletContextListener(TeamAppsCore teamAppsCore) {
        this.teamAppsCore = teamAppsCore;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext context = servletContextEvent.getServletContext();
        FilterRegistration.Dynamic indexHtmlHeaderFilter = context.addFilter("teamapps-index-html-header-filter", (Filter)new IndexHtmlHeaderFilter());
        indexHtmlHeaderFilter.setAsyncSupported(true);
        indexHtmlHeaderFilter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/"});
        indexHtmlHeaderFilter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/index.html"});
        FilterRegistration.Dynamic downloadFilterRegistration = context.addFilter("teamapps-download-header-filter", (Filter)new DownloadHttpHeaderFilter());
        downloadFilterRegistration.setAsyncSupported(true);
        downloadFilterRegistration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"*"});
        ServletRegistration.Dynamic uploadServletRegistration = context.addServlet("teamapps-upload-servlet", (Servlet)new UploadServlet(this.teamAppsCore.getConfig().getUploadDirectory(), this.teamAppsCore.getUploadManager()::addUploadedFile));
        uploadServletRegistration.addMapping(new String[]{"/upload/*"});
        uploadServletRegistration.setMultipartConfig(new MultipartConfigElement(null, -1L, -1L, 1000000));
        ServletRegistration.Dynamic leaveBeaconServletRegistration = context.addServlet("teamapps-leave", (Servlet)new LeaveBeaconServlet(this.teamAppsCore.getSessionManager()));
        leaveBeaconServletRegistration.addMapping(new String[]{"/leave/*"});
        ServletRegistration.Dynamic iconServletRegistration = context.addServlet("teamapps-icons", (Servlet)new ResourceProviderServlet(new IconResourceProvider(new IconProvider(this.teamAppsCore.getIconLibraryRegistry()))));
        iconServletRegistration.addMapping(new String[]{"/icons/*"});
        ServletRegistration.Dynamic filesServletRegistration = context.addServlet("teamapps-files", (Servlet)new ResourceProviderServlet(new SessionResourceProvider(this.teamAppsCore.getSessionManager()::getSessionContextById)));
        filesServletRegistration.addMapping(new String[]{"/files/*"});
        context.addListener((EventListener)((Object)new ServletRequestListener()));
        context.addListener((EventListener)((Object)this.teamAppsCore.getSessionManager()));
        try {
            ServerContainer serverContainer = (ServerContainer)context.getAttribute("javax.websocket.server.ServerContainer");
            ServerEndpointConfig communicationEndpointConfig = ServerEndpointConfig.Builder.create(WebSocketCommunicationEndpoint.class, (String)"/communication").configurator((ServerEndpointConfig.Configurator)new WebSocketServerEndpointConfigurator(this.teamAppsCore.getWebSocketCommunicationEndpoint())).extensions(List.of(new WebsocketExtension("permessage-deflate"))).build();
            serverContainer.addEndpoint(communicationEndpointConfig);
        }
        catch (Exception e) {
            String msg = "Could not register TeamApps communication endpoint";
            LOGGER.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.teamAppsCore.getSessionManager().destroy();
    }

    private static class WebsocketExtension
    implements Extension {
        private final String name;

        public WebsocketExtension(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<Extension.Parameter> getParameters() {
            return List.of();
        }
    }
}

