/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.model.timestamps;

import java.time.Instant;
import java.time.ZoneId;
import java.util.stream.Collectors;
import org.teamapps.event.Event;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.TimePartitioning;
import org.teamapps.ux.component.timegraph.datapoints.LineGraphData;
import org.teamapps.ux.component.timegraph.datapoints.LineGraphDataPoint;
import org.teamapps.ux.component.timegraph.datapoints.ListLineGraphData;
import org.teamapps.ux.component.timegraph.model.AbstractLineGraphModel;
import org.teamapps.ux.component.timegraph.model.timestamps.TimestampsModel;
import org.teamapps.ux.component.timegraph.model.timestamps.TimestampsPartitioner;

public class PartitioningTimestampsLineGraphModel
extends AbstractLineGraphModel {
    private final TimestampsModel timestampsModel;

    public PartitioningTimestampsLineGraphModel(TimestampsModel timestampsModel) {
        this.timestampsModel = timestampsModel;
        this.timestampsModel.onDataChanged().addListener(this.onDataChanged::fire);
    }

    @Override
    public Event<Void> onDataChanged() {
        return this.onDataChanged;
    }

    @Override
    public LineGraphData getData(TimePartitioning zoomLevel, ZoneId zoneId, Interval neededInterval, Interval displayedInterval) {
        long queryStart = zoomLevel.getPartitionStart(Instant.ofEpochMilli(displayedInterval.getMin()).atZone(zoneId)).toInstant().toEpochMilli();
        long queryEnd = zoomLevel.getPartitionEnd(Instant.ofEpochMilli(displayedInterval.getMax()).atZone(zoneId)).toInstant().toEpochMilli();
        long[] eventTimestamps = this.timestampsModel.getTimestamps(displayedInterval);
        return new ListLineGraphData(TimestampsPartitioner.partition(queryStart, queryEnd, eventTimestamps, zoneId, zoomLevel, true).stream().map(p -> new LineGraphDataPoint(p.getTimestamp(), p.getCount())).collect(Collectors.toList()), new Interval(queryStart, queryEnd));
    }

    @Override
    public Interval getDomainX() {
        return this.timestampsModel.getDomainX();
    }
}

