/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.cache.record.legacy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.util.StreamUtil;
import org.teamapps.ux.cache.record.legacy.CacheManipulationHandle;
import org.teamapps.ux.cache.record.legacy.ClientRecordCachePurgeListener;

public class ClientRecordCache<RECORD, UIRECORD extends UiIdentifiableClientRecord> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientRecordCache.class);
    private final UiIdentifiableClientRecordFactory<RECORD, UIRECORD> clientRecordFactory;
    private final UiIdentifiableClientRecordPostProcessor<RECORD, UIRECORD> postProcessor;
    private int idCounter;
    private int nextOperationSequenceNumber = 0;
    private int operationInvalidationSequenceNumber = -1;
    private ClientRecordCachePurgeListener purgeListener;
    private BiPredicate<RECORD, Integer> purgeDecider = (record, clientRecordId) -> true;
    private int maxCapacity = Integer.MAX_VALUE;
    private LinkedHashMap<RECORD, Integer> uiRecordsByRecord = new LinkedHashMap();
    private LinkedHashMap<Integer, RECORD> recordsByClientId = new LinkedHashMap();
    private LinkedHashMap<Integer, RECORD> unacknowledgedRecordsByClientId = new LinkedHashMap();

    public ClientRecordCache(UiIdentifiableClientRecordFactory<RECORD, UIRECORD> clientRecordFactory, UiIdentifiableClientRecordPostProcessor<RECORD, UIRECORD> postProcessor) {
        this.clientRecordFactory = clientRecordFactory;
        this.postProcessor = postProcessor;
    }

    public ClientRecordCache(UiIdentifiableClientRecordFactory<RECORD, UIRECORD> clientRecordFactory) {
        this(clientRecordFactory, (record, uiRecord, allNewUiRecords) -> {});
    }

    public Integer getUiRecordIdOrNull(RECORD record) {
        if (record == null) {
            return null;
        }
        return this.uiRecordsByRecord.get(record);
    }

    public List<Integer> getUiRecordIds(List<RECORD> records) {
        return records.stream().map(record -> this.getUiRecordIdOrNull(record)).filter(clientId -> clientId != null).collect(Collectors.toList());
    }

    public RECORD getRecordByClientId(int id) {
        RECORD record = this.recordsByClientId.get(id);
        if (record == null) {
            record = this.unacknowledgedRecordsByClientId.get(id);
        }
        if (record == null) {
            LOGGER.error("Could not find record for ID from client! Client id: " + id);
        }
        return record;
    }

    public CacheManipulationHandle<Void> clear() {
        this.uiRecordsByRecord.clear();
        return new CacheManipulationHandle<Object>(this, this.nextOperationSequenceNumber++, null, () -> this.recordsByClientId.clear());
    }

    public CacheManipulationHandle<List<UIRECORD>> replaceRecords(List<RECORD> newRecords) {
        this.purgeIfNeeded(this.maxCapacity);
        LinkedHashMap<RECORD, UIRECORD> uiRecordsByRecord = this.createUiRecords(newRecords);
        this.uiRecordsByRecord.clear();
        this.uiRecordsByRecord.putAll(uiRecordsByRecord.entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey(), entry -> ((UiIdentifiableClientRecord)entry.getValue()).getId())));
        Map<Integer, Object> newRecordsByClientId = uiRecordsByRecord.entrySet().stream().collect(Collectors.toMap(entry -> ((UiIdentifiableClientRecord)entry.getValue()).getId(), Map.Entry::getKey));
        this.unacknowledgedRecordsByClientId.putAll(newRecordsByClientId);
        return new CacheManipulationHandle<List<UIRECORD>>(this, this.nextOperationSequenceNumber++, new ArrayList<UIRECORD>(uiRecordsByRecord.values()), () -> {
            this.recordsByClientId.putAll(newRecordsByClientId);
            this.unacknowledgedRecordsByClientId.keySet().removeAll(newRecordsByClientId.keySet());
        });
    }

    public CacheManipulationHandle<List<UIRECORD>> addRecords(List<RECORD> newRecords) {
        this.purgeIfNeeded(newRecords.size());
        LinkedHashMap<RECORD, UIRECORD> uiRecordsByRecord = this.createUiRecords(newRecords);
        this.uiRecordsByRecord.putAll((Map)uiRecordsByRecord.entrySet().stream().collect(StreamUtil.toLinkedHashMap(entry -> entry.getKey(), entry -> ((UiIdentifiableClientRecord)entry.getValue()).getId())));
        Map<Integer, Object> newRecordsByClientId = uiRecordsByRecord.entrySet().stream().collect(Collectors.toMap(entry -> ((UiIdentifiableClientRecord)entry.getValue()).getId(), Map.Entry::getKey));
        this.unacknowledgedRecordsByClientId.putAll(newRecordsByClientId);
        return new CacheManipulationHandle<List<UIRECORD>>(this, this.nextOperationSequenceNumber++, new ArrayList<UIRECORD>(uiRecordsByRecord.values()), () -> {
            this.recordsByClientId.putAll(newRecordsByClientId);
            this.unacknowledgedRecordsByClientId.keySet().removeAll(newRecordsByClientId.keySet());
        });
    }

    public CacheManipulationHandle<UIRECORD> addRecord(RECORD record) {
        this.purgeIfNeeded(1);
        UIRECORD uiRecord = this.createUiRecord(record);
        this.postProcessor.postProcess(record, uiRecord, Collections.singletonMap(record, uiRecord));
        this.uiRecordsByRecord.put(record, uiRecord.getId());
        this.unacknowledgedRecordsByClientId.put(uiRecord.getId(), record);
        return new CacheManipulationHandle<UIRECORD>(this, this.nextOperationSequenceNumber++, uiRecord, () -> {
            this.recordsByClientId.put(uiRecord.getId(), record);
            this.unacknowledgedRecordsByClientId.remove(uiRecord.getId());
        });
    }

    public CacheManipulationHandle<UIRECORD> addOrUpdateRecord(RECORD record) {
        Integer oldUiRecord = this.getUiRecordIdOrNull(record);
        UIRECORD newUiRecord = this.createUiRecord(record);
        this.postProcessor.postProcess(record, newUiRecord, Collections.singletonMap(record, newUiRecord));
        if (oldUiRecord != null) {
            newUiRecord.setId(oldUiRecord.intValue());
        } else {
            this.purgeIfNeeded(1);
        }
        this.uiRecordsByRecord.put(record, newUiRecord.getId());
        this.unacknowledgedRecordsByClientId.put(newUiRecord.getId(), record);
        return new CacheManipulationHandle<UIRECORD>(this, this.nextOperationSequenceNumber++, newUiRecord, () -> {
            this.recordsByClientId.put(newUiRecord.getId(), record);
            this.unacknowledgedRecordsByClientId.remove(newUiRecord.getId());
        });
    }

    public CacheManipulationHandle<Integer> removeRecord(RECORD record) {
        Integer uiRecord = (Integer)this.uiRecordsByRecord.remove(record);
        return new CacheManipulationHandle<Integer>(this, this.nextOperationSequenceNumber++, uiRecord, () -> this.recordsByClientId.remove(uiRecord));
    }

    public CacheManipulationHandle<List<Integer>> removeRecords(Collection<RECORD> recordToBeRemoved) {
        ArrayList removedUiIds = new ArrayList();
        this.uiRecordsByRecord.entrySet().removeIf(entry -> {
            boolean toBeRemoved = recordToBeRemoved.contains(entry.getKey());
            if (toBeRemoved) {
                removedUiIds.add((Integer)entry.getValue());
            }
            return toBeRemoved;
        });
        return new CacheManipulationHandle<List<Integer>>(this, this.nextOperationSequenceNumber++, removedUiIds, () -> this.recordsByClientId.entrySet().removeIf(entry -> removedUiIds.contains(entry.getKey())));
    }

    public void hardReplaceRecords(Map<RECORD, Integer> newRecords) {
        this.uiRecordsByRecord.clear();
        this.uiRecordsByRecord.putAll(newRecords);
        this.recordsByClientId.clear();
        this.recordsByClientId.putAll(newRecords.entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getValue(), entry -> entry.getKey())));
        this.unacknowledgedRecordsByClientId.clear();
        this.operationInvalidationSequenceNumber = this.nextOperationSequenceNumber - 1;
    }

    private void purgeIfNeeded(int numberOfRecordsToBeAdded) {
        int numberOfRecordsToBeRemovedFromNonAcknowledgedRecordsByClientId;
        int numberOfRecordsToBeRemoved = this.uiRecordsByRecord.size() + numberOfRecordsToBeAdded - this.maxCapacity;
        if (numberOfRecordsToBeRemoved > 0) {
            List<Integer> removedClientRecordIds = ClientRecordCache.removeEldestEntries(this.uiRecordsByRecord, numberOfRecordsToBeRemoved, this.purgeDecider);
            if (this.purgeListener != null) {
                this.purgeListener.handleCacheEntriesPurged(new CacheManipulationHandle<List<Integer>>(this, this.nextOperationSequenceNumber++, removedClientRecordIds, () -> this.recordsByClientId.keySet().removeAll(removedClientRecordIds)));
            }
        }
        if ((numberOfRecordsToBeRemovedFromNonAcknowledgedRecordsByClientId = this.unacknowledgedRecordsByClientId.size() + numberOfRecordsToBeAdded - Math.max(2000, this.maxCapacity)) > 0) {
            ClientRecordCache.removeEldestEntries(this.unacknowledgedRecordsByClientId, numberOfRecordsToBeRemoved, (key, value) -> true);
        }
    }

    private static <K, V> List<V> removeEldestEntries(LinkedHashMap<K, V> map, int numberOfRecordsToBeRemoved, BiPredicate<K, V> purgePredicate) {
        ArrayList<V> removedRecords = new ArrayList<V>();
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext() && removedRecords.size() < numberOfRecordsToBeRemoved) {
            Map.Entry<K, V> entry = iterator.next();
            if (!purgePredicate.test(entry.getKey(), entry.getValue())) continue;
            iterator.remove();
            removedRecords.add(entry.getValue());
        }
        return removedRecords;
    }

    private LinkedHashMap<RECORD, UIRECORD> createUiRecords(List<RECORD> newRecords) {
        LinkedHashMap<Object, UiIdentifiableClientRecord> uiRecordsByRecord = newRecords.stream().collect(StreamUtil.toLinkedHashMap(record -> record, record -> this.createUiRecord(record)));
        uiRecordsByRecord.forEach((record, uiRecord) -> this.postProcessor.postProcess(record, (UiIdentifiableClientRecord)uiRecord, (Map<Object, UiIdentifiableClientRecord>)uiRecordsByRecord));
        return uiRecordsByRecord;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.purgeIfNeeded(0);
    }

    public ClientRecordCachePurgeListener getPurgeListener() {
        return this.purgeListener;
    }

    public void setPurgeListener(ClientRecordCachePurgeListener purgeListener) {
        this.purgeListener = purgeListener;
    }

    private UIRECORD createUiRecord(RECORD record) {
        UiIdentifiableClientRecord uiRecord = (UiIdentifiableClientRecord)this.clientRecordFactory.create(record);
        uiRecord.setId(++this.idCounter);
        return (UIRECORD)uiRecord;
    }

    public int getOperationInvalidationSequenceNumber() {
        return this.operationInvalidationSequenceNumber;
    }

    public Map<Integer, RECORD> getAllRecords(boolean includingAcknowledged) {
        HashMap<Integer, RECORD> result = new HashMap<Integer, RECORD>(this.recordsByClientId);
        if (includingAcknowledged) {
            result.putAll(this.unacknowledgedRecordsByClientId);
        }
        return result;
    }

    public <ID> boolean containsExactly(List<RECORD> records, Function<RECORD, ID> identifierExtractor, BiPredicate<RECORD, RECORD> recordsEqual) {
        if (this.uiRecordsByRecord.size() != records.size()) {
            return false;
        }
        Map cachedRecordsById = this.uiRecordsByRecord.keySet().stream().collect(Collectors.toMap(identifierExtractor, Function.identity()));
        for (RECORD record : records) {
            ID recordId = identifierExtractor.apply(record);
            Object cachedRecord = cachedRecordsById.get(recordId);
            if (cachedRecord != null && recordsEqual.test(record, cachedRecord)) continue;
            return false;
        }
        return true;
    }

    public BiPredicate<RECORD, Integer> getPurgeDecider() {
        return this.purgeDecider;
    }

    public void setPurgeDecider(BiPredicate<RECORD, Integer> purgeDecider) {
        this.purgeDecider = purgeDecider;
    }

    public static interface UiIdentifiableClientRecordFactory<RECORD, UIRECORD> {
        public UIRECORD create(RECORD var1);
    }

    public static interface UiIdentifiableClientRecordPostProcessor<RECORD, UIRECORD> {
        public void postProcess(RECORD var1, UIRECORD var2, Map<RECORD, UIRECORD> var3);
    }
}

