/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.form.layoutpolicy;

import org.teamapps.dto.UiFormSectionFieldPlacement;
import org.teamapps.dto.UiFormSectionPlacement;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.form.layoutpolicy.FormSectionPlacement;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.VerticalElementAlignment;

public class FormSectionFieldPlacement
implements FormSectionPlacement {
    private Component field;
    private int row;
    private int column;
    private int rowSpan = 1;
    private int colSpan = 1;
    private int minWidth;
    private int maxWidth;
    private int minHeight;
    private int maxHeight;
    private VerticalElementAlignment verticalAlignment = VerticalElementAlignment.CENTER;
    private HorizontalElementAlignment horizontalAlignment = HorizontalElementAlignment.LEFT;

    public FormSectionFieldPlacement() {
    }

    public FormSectionFieldPlacement(Component field, int row, int column) {
        this.field = field;
        this.row = row;
        this.column = column;
    }

    public FormSectionFieldPlacement createCopy() {
        FormSectionFieldPlacement placement = new FormSectionFieldPlacement(this.field, this.row, this.column);
        placement.setColumn(this.column);
        placement.setRow(this.row);
        placement.setRowSpan(this.rowSpan);
        placement.setColSpan(this.colSpan);
        placement.setMinWidth(this.minWidth);
        placement.setMaxWidth(this.maxWidth);
        placement.setMinHeight(this.minHeight);
        placement.setMaxHeight(this.maxHeight);
        placement.setVerticalAlignment(this.verticalAlignment);
        placement.setHorizontalAlignment(this.horizontalAlignment);
        return placement;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    public FormSectionFieldPlacement setRow(int row) {
        this.row = row;
        return this;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    public FormSectionFieldPlacement setColumn(int column) {
        this.column = column;
        return this;
    }

    @Override
    public int getRowSpan() {
        return this.rowSpan;
    }

    public FormSectionFieldPlacement setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
        return this;
    }

    @Override
    public int getColSpan() {
        return this.colSpan;
    }

    public FormSectionFieldPlacement setColSpan(int colSpan) {
        this.colSpan = colSpan;
        return this;
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    public FormSectionFieldPlacement setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public FormSectionFieldPlacement setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    @Override
    public VerticalElementAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public FormSectionFieldPlacement setVerticalAlignment(VerticalElementAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @Override
    public HorizontalElementAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public FormSectionFieldPlacement setHorizontalAlignment(HorizontalElementAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @Override
    public int getMinWidth() {
        return this.minWidth;
    }

    public FormSectionFieldPlacement setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public FormSectionFieldPlacement setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    @Override
    public UiFormSectionPlacement createUiFormSectionPlacement() {
        return new UiFormSectionFieldPlacement(this.field.createUiComponentReference()).setRow(this.row).setColumn(this.column).setRowSpan(this.rowSpan).setColSpan(this.colSpan).setMinWidth(this.minWidth).setMaxWidth(this.maxWidth).setMinHeight(this.minHeight).setMaxHeight(this.maxHeight).setVerticalAlignment(this.verticalAlignment.toUiVerticalElementAlignment()).setHorizontalAlignment(this.horizontalAlignment.toUiHorizontalElementAlignment());
    }

    public String toString() {
        return "FormSectionFieldPlacement{field='" + this.field + "', row=" + this.row + ", column=" + this.column + ", rowSpan=" + this.rowSpan + ", colSpan=" + this.colSpan + "}";
    }
}

