/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.imagecropper;

import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiImageCropper;
import org.teamapps.dto.UiImageCropperSelection;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.imagecropper.ImageCropperSelection;
import org.teamapps.ux.component.imagecropper.ImageCropperSelectionMode;

public class ImageCropper
extends AbstractComponent {
    public final Event<ImageCropperSelection> onSelectionChanged = new Event();
    private String imageUrl;
    private ImageCropperSelectionMode selectionMode = ImageCropperSelectionMode.RECTANGLE;
    private float aspectRatio = 1.0f;
    private ImageCropperSelection selection;

    @Override
    public UiComponent createUiComponent() {
        UiImageCropper uiImageCropper = new UiImageCropper(this.imageUrl, this.selectionMode.toUiImageCropperSelectionMode(), this.aspectRatio);
        this.mapAbstractUiComponentProperties((UiComponent)uiImageCropper);
        return uiImageCropper;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_IMAGE_CROPPER_SELECTION_CHANGED: {
                ImageCropperSelection selection;
                UiImageCropperSelection uiSelection = ((UiImageCropper.SelectionChangedEvent)event).getSelection();
                this.selection = selection = new ImageCropperSelection(uiSelection.getLeft(), uiSelection.getTop(), uiSelection.getWidth(), uiSelection.getHeight());
                this.onSelectionChanged.fire(selection);
                break;
            }
        }
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        this.queueCommandIfRendered(() -> new UiImageCropper.SetImageUrlCommand(this.getId(), imageUrl));
    }

    public ImageCropperSelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(ImageCropperSelectionMode selectionMode) {
        this.selectionMode = selectionMode;
        this.queueCommandIfRendered(() -> new UiImageCropper.SetSelectionModeCommand(this.getId(), selectionMode.toUiImageCropperSelectionMode()));
    }

    public Float getAspectRatio() {
        return Float.valueOf(this.aspectRatio);
    }

    public void setAspectRatio(Float aspectRatio) {
        this.aspectRatio = aspectRatio.floatValue();
        this.queueCommandIfRendered(() -> new UiImageCropper.SetAspectRatioCommand(this.getId(), aspectRatio.floatValue()));
    }

    public ImageCropperSelection getSelection() {
        return this.selection;
    }

    public void setSelection(ImageCropperSelection selection) {
        this.selection = selection;
        this.queueCommandIfRendered(() -> new UiImageCropper.SetSelectionCommand(this.getId(), selection.createUiImageCropperSelection()));
    }

    @Override
    protected void doDestroy() {
    }
}

