/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.infiniteitemview;

import java.util.Collections;
import java.util.List;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.dto.UiInfiniteItemView;
import org.teamapps.event.Event;
import org.teamapps.event.EventListener;
import org.teamapps.ux.cache.CacheManipulationHandle;
import org.teamapps.ux.cache.ClientRecordCache;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemViewModel;
import org.teamapps.ux.component.infiniteitemview.ItemClickedEventData;
import org.teamapps.ux.component.infiniteitemview.ListInfiniteItemViewModel;
import org.teamapps.ux.component.itemview.ItemViewItemJustification;
import org.teamapps.ux.component.itemview.ItemViewVerticalItemAlignment;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class InfiniteItemView<RECORD>
extends AbstractComponent {
    public final Event<ItemClickedEventData<RECORD>> onItemClicked = new Event();
    private int numberOfInitialRecords = 100;
    private Template itemTemplate;
    private float itemWidth;
    private int rowHeight;
    private int horizontalItemMargin = 0;
    private ItemViewItemJustification itemJustification = ItemViewItemJustification.LEFT;
    private ItemViewVerticalItemAlignment verticalItemAlignment = ItemViewVerticalItemAlignment.STRETCH;
    private InfiniteItemViewModel<RECORD> model = new ListInfiniteItemViewModel(Collections.emptyList());
    private PropertyExtractor<RECORD> itemPropertyExtractor = new BeanPropertyExtractor();
    private final ClientRecordCache<RECORD, UiIdentifiableClientRecord> itemCache;
    private EventListener<Void> modelOnAllDataChangedListener = aVoid -> this.resetClientSideData();
    private EventListener<RECORD> modelOnRecordAddedListener = record -> this.resetClientSideData();
    private EventListener<RECORD> modelOnRecordChangedListener = record -> this.resetClientSideData();
    private EventListener<RECORD> modelOnRecordDeletedListener = record -> this.resetClientSideData();

    public InfiniteItemView(Template itemTemplate, float itemWidth, int rowHeight) {
        this.itemTemplate = itemTemplate;
        this.itemWidth = itemWidth;
        this.rowHeight = rowHeight;
        this.itemCache = new ClientRecordCache<Object, UiIdentifiableClientRecord>(this::createUiIdentifiableClientRecord);
        this.itemCache.setMaxCapacity(1000);
        this.itemCache.setPurgeListener(operationHandle -> {
            if (this.isRendered()) {
                List removedItemIds = (List)operationHandle.getResult();
                this.getSessionContext().queueCommand(new UiInfiniteItemView.RemoveDataCommand(this.getId(), removedItemIds), aVoid -> operationHandle.commit());
            } else {
                operationHandle.commit();
            }
        });
    }

    public InfiniteItemView(float itemWidth, int itemHeight) {
        this(BaseTemplate.ITEM_VIEW_ITEM, itemWidth, itemHeight);
    }

    public InfiniteItemView() {
        this(BaseTemplate.ITEM_VIEW_ITEM, 300.0f, 300);
    }

    @Override
    public UiComponent createUiComponent() {
        UiInfiniteItemView uiComponent = new UiInfiniteItemView(this.itemTemplate.createUiTemplate(), this.rowHeight);
        this.mapAbstractUiComponentProperties((UiComponent)uiComponent);
        int recordCount = this.model.getCount();
        CacheManipulationHandle<List<UiIdentifiableClientRecord>> cacheResponse = this.itemCache.replaceRecords(this.model.getRecords(0, Math.min(recordCount, this.numberOfInitialRecords)));
        cacheResponse.commit();
        uiComponent.setData(cacheResponse.getResult());
        uiComponent.setTotalNumberOfRecords(recordCount);
        uiComponent.setItemWidth(this.itemWidth);
        uiComponent.setHorizontalItemMargin(this.horizontalItemMargin);
        uiComponent.setItemJustification(this.itemJustification.toUiItemJustification());
        uiComponent.setVerticalItemAlignment(this.verticalItemAlignment.toUiItemJustification());
        return uiComponent;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_INFINITE_ITEM_VIEW_DATA_REQUEST: {
                UiInfiniteItemView.DataRequestEvent dataRequestEvent = (UiInfiniteItemView.DataRequestEvent)event;
                int startIndex = dataRequestEvent.getStartIndex();
                int length = dataRequestEvent.getLength();
                this.sendRecords(startIndex, length, false);
                break;
            }
            case UI_INFINITE_ITEM_VIEW_ITEM_CLICKED: {
                UiInfiniteItemView.ItemClickedEvent itemClickedEvent = (UiInfiniteItemView.ItemClickedEvent)event;
                RECORD record = this.itemCache.getRecordByClientId(itemClickedEvent.getRecordId());
                if (record == null) break;
                this.onItemClicked.fire(new ItemClickedEventData<RECORD>(record, itemClickedEvent.getIsDoubleClick()));
            }
        }
    }

    private UiIdentifiableClientRecord createUiIdentifiableClientRecord(RECORD record) {
        UiIdentifiableClientRecord clientRecord = new UiIdentifiableClientRecord();
        clientRecord.setValues(this.itemPropertyExtractor.getValues(record, this.itemTemplate.getDataKeys()));
        return clientRecord;
    }

    public int getNumberOfInitialRecords() {
        return this.numberOfInitialRecords;
    }

    public InfiniteItemView<RECORD> setNumberOfInitialRecords(int numberOfInitialRecords) {
        this.numberOfInitialRecords = numberOfInitialRecords;
        return this;
    }

    public Template getItemTemplate() {
        return this.itemTemplate;
    }

    public InfiniteItemView<RECORD> setItemTemplate(Template itemTemplate) {
        this.itemTemplate = itemTemplate;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView.SetItemTemplateCommand(this.getId(), itemTemplate.createUiTemplate()));
        return this;
    }

    public float getItemWidth() {
        return this.itemWidth;
    }

    public InfiniteItemView<RECORD> setItemWidth(float itemWidth) {
        this.itemWidth = itemWidth;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView.SetItemWidthCommand(this.getId(), itemWidth));
        return this;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
        this.reRenderIfRendered();
    }

    public ItemViewVerticalItemAlignment getVerticalItemAlignment() {
        return this.verticalItemAlignment;
    }

    public void setVerticalItemAlignment(ItemViewVerticalItemAlignment verticalItemAlignment) {
        this.verticalItemAlignment = verticalItemAlignment;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView.SetVerticalItemAlignmentCommand(this.getId(), verticalItemAlignment.toUiItemJustification()));
    }

    public int getHorizontalItemMargin() {
        return this.horizontalItemMargin;
    }

    public InfiniteItemView<RECORD> setHorizontalItemMargin(int horizontalItemMargin) {
        this.horizontalItemMargin = horizontalItemMargin;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView.SetHorizontalItemMarginCommand(this.getId(), horizontalItemMargin));
        return this;
    }

    public ItemViewItemJustification getItemJustification() {
        return this.itemJustification;
    }

    public InfiniteItemView<RECORD> setItemJustification(ItemViewItemJustification itemJustification) {
        this.itemJustification = itemJustification;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView.SetItemJustificationCommand(this.getId(), itemJustification.toUiItemJustification()));
        return this;
    }

    public InfiniteItemViewModel<RECORD> getModel() {
        return this.model;
    }

    public PropertyExtractor<RECORD> getItemPropertyExtractor() {
        return this.itemPropertyExtractor;
    }

    public void setItemPropertyExtractor(PropertyExtractor<RECORD> itemPropertyExtractor) {
        this.itemPropertyExtractor = itemPropertyExtractor;
    }

    public InfiniteItemView<RECORD> setModel(InfiniteItemViewModel<RECORD> model) {
        this.unregisterModelListeners();
        this.model = model;
        this.resetClientSideData();
        model.onAllDataChanged().addListener(this.modelOnAllDataChangedListener);
        model.onRecordAdded().addListener(this.modelOnRecordAddedListener);
        model.onRecordChanged().addListener(this.modelOnRecordChangedListener);
        model.onRecordDeleted().addListener(this.modelOnRecordDeletedListener);
        return this;
    }

    private void unregisterModelListeners() {
        this.model.onAllDataChanged().removeListener(this.modelOnAllDataChangedListener);
        this.model.onRecordAdded().removeListener(this.modelOnRecordAddedListener);
        this.model.onRecordChanged().removeListener(this.modelOnRecordChangedListener);
        this.model.onRecordDeleted().removeListener(this.modelOnRecordDeletedListener);
    }

    private void resetClientSideData() {
        this.sendRecords(0, this.numberOfInitialRecords, true);
    }

    private void sendRecords(int startIndex, int length, boolean clear) {
        if (this.isRendered()) {
            int totalCount = this.model.getCount();
            List<RECORD> records = this.model.getRecords(startIndex, Math.min(totalCount - startIndex, length));
            CacheManipulationHandle<List<UiIdentifiableClientRecord>> cacheResponse = clear ? this.itemCache.replaceRecords(records) : this.itemCache.addRecords(records);
            this.getSessionContext().queueCommand(new UiInfiniteItemView.AddDataCommand(this.getId(), startIndex, cacheResponse.getResult(), totalCount, clear), aVoid -> cacheResponse.commit());
        }
    }

    public void setMaxCacheCapacity(int maxCapacity) {
        this.itemCache.setMaxCapacity(maxCapacity);
    }

    @Override
    protected void doDestroy() {
        this.unregisterModelListeners();
    }
}

