/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.infiniteitemview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teamapps.ux.component.infiniteitemview.AbstractInfiniteItemViewModel;

public class ListInfiniteItemViewModel<RECORD>
extends AbstractInfiniteItemViewModel<RECORD> {
    private List<RECORD> records;

    public ListInfiniteItemViewModel() {
        this.records = new ArrayList<RECORD>();
    }

    public ListInfiniteItemViewModel(List<RECORD> records) {
        this.records = records;
    }

    public void addRecord(RECORD record) {
        this.records.add(record);
        this.onRecordAdded.fire(record);
    }

    public void setRecords(List<RECORD> records) {
        this.records = records;
        this.onAllDataChanged.fire(null);
    }

    @Override
    public int getCount() {
        return this.records.size();
    }

    @Override
    public List<RECORD> getRecords(int startIndex, int length) {
        if (startIndex >= this.records.size()) {
            return Collections.emptyList();
        }
        if (startIndex + length > this.records.size()) {
            length = this.records.size() - startIndex;
        }
        return this.records.subList(startIndex, startIndex + length);
    }
}

