/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.teamapps.ux.component.template.BaseTemplateTreeNode;
import org.teamapps.ux.component.tree.EagerNodesFilter;
import org.teamapps.ux.model.AbstractTreeModel;
import org.teamapps.ux.model.TreeModelChangedEventData;

public class SimpleTreeModel<PAYLOAD>
extends AbstractTreeModel<BaseTemplateTreeNode<PAYLOAD>> {
    private final List<BaseTemplateTreeNode<PAYLOAD>> nodes;
    private int maxResultNodes = Integer.MAX_VALUE;

    public SimpleTreeModel() {
        this.nodes = new ArrayList<BaseTemplateTreeNode<PAYLOAD>>();
    }

    public SimpleTreeModel(List<BaseTemplateTreeNode<PAYLOAD>> nodes) {
        this.nodes = new ArrayList<BaseTemplateTreeNode<PAYLOAD>>(nodes);
    }

    public void setNodes(List<BaseTemplateTreeNode<PAYLOAD>> nodes) {
        this.nodes.clear();
        this.nodes.addAll(nodes);
        this.onAllNodesChanged.fire(nodes);
    }

    public void addNode(BaseTemplateTreeNode<PAYLOAD> node) {
        this.nodes.add(node);
        this.onChanged.fire(new TreeModelChangedEventData<BaseTemplateTreeNode<PAYLOAD>>(Collections.emptyList(), Collections.singletonList(node)));
    }

    public void addNodes(List<BaseTemplateTreeNode<PAYLOAD>> nodes) {
        this.nodes.addAll(nodes);
        this.onChanged.fire(new TreeModelChangedEventData<BaseTemplateTreeNode<PAYLOAD>>(Collections.emptyList(), nodes));
    }

    public void removeChildren(Collection<BaseTemplateTreeNode<PAYLOAD>> parents) {
        this.replaceChildren(parents, Collections.emptyList());
    }

    public void replaceChildren(Collection<BaseTemplateTreeNode<PAYLOAD>> parentsToEmpty, List<BaseTemplateTreeNode<PAYLOAD>> nodesToAdd) {
        List nodesToBeRemoved = this.nodes.stream().filter(node -> node.isDescendantOf(parentsToEmpty)).collect(Collectors.toList());
        this.nodes.removeAll(nodesToBeRemoved);
        this.nodes.addAll(nodesToAdd);
        this.onChanged.fire(new TreeModelChangedEventData<BaseTemplateTreeNode<PAYLOAD>>(nodesToBeRemoved, nodesToAdd));
    }

    public void updateNode(BaseTemplateTreeNode<PAYLOAD> node) {
        this.onChanged.fire(new TreeModelChangedEventData<BaseTemplateTreeNode<PAYLOAD>>(Collections.emptyList(), Collections.singletonList(node)));
    }

    public void relocateNode(BaseTemplateTreeNode<PAYLOAD> node) {
        this.onChanged.fire(new TreeModelChangedEventData<BaseTemplateTreeNode<PAYLOAD>>(Collections.singletonList(node), Collections.singletonList(node)));
    }

    public void removeNode(BaseTemplateTreeNode<PAYLOAD> node) {
        this.nodes.remove(node);
        this.onChanged.fire(new TreeModelChangedEventData<BaseTemplateTreeNode<PAYLOAD>>(Collections.singletonList(node), Collections.emptyList()));
    }

    public void removeAllNodes() {
        this.nodes.clear();
        this.onAllNodesChanged.fire(Collections.emptyList());
    }

    public int getMaxResultNodes() {
        return this.maxResultNodes;
    }

    public void setMaxResultNodes(int maxResultNodes) {
        this.maxResultNodes = maxResultNodes;
    }

    @Override
    public List<BaseTemplateTreeNode<PAYLOAD>> getRecords(String query) {
        if (StringUtils.isEmpty((CharSequence)query)) {
            return this.nodes.stream().filter(new EagerNodesFilter()).limit(this.maxResultNodes).collect(Collectors.toList());
        }
        List filteredTree = this.nodes.stream().filter(node -> StringUtils.containsIgnoreCase((CharSequence)node.getCaption(), (CharSequence)query)).flatMap(node -> node.getPath().stream()).distinct().collect(Collectors.toList());
        List treeCopy = BaseTemplateTreeNode.copyTree(filteredTree);
        treeCopy.forEach(node -> node.setExpanded(true));
        return treeCopy;
    }

    @Override
    public List<BaseTemplateTreeNode<PAYLOAD>> getChildRecords(BaseTemplateTreeNode<PAYLOAD> parentRecord) {
        return this.nodes.stream().filter(record -> record.getPath().contains(parentRecord) && record != parentRecord).filter(new EagerNodesFilter(parentRecord)).collect(Collectors.toList());
    }
}

