/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.resource;

import java.io.File;
import java.io.InputStream;
import java.util.Date;
import org.teamapps.icons.api.CustomIconStyle;
import org.teamapps.icons.provider.IconProvider;
import org.teamapps.icons.systemprovider.IconResource;
import org.teamapps.icons.systemprovider.SystemIconProvider;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.resource.ResourceProvider;

public class SystemIconResourceProvider
implements ResourceProvider {
    private Date lastModifiedDate = new Date();
    private final SystemIconProvider iconProvider;

    public SystemIconResourceProvider() {
        this.iconProvider = new SystemIconProvider();
    }

    public SystemIconResourceProvider(File cachingDirectory) {
        this.iconProvider = new SystemIconProvider(cachingDirectory);
    }

    @Override
    public Resource getResource(String servletPath, String relativeResourcePath, String httpSessionId) {
        String iconId;
        String[] parts;
        int size;
        IconResource iconResource;
        if (relativeResourcePath == null) {
            return null;
        }
        if (relativeResourcePath.startsWith("/")) {
            relativeResourcePath = relativeResourcePath.substring(1);
        }
        if (relativeResourcePath.endsWith("/")) {
            relativeResourcePath = relativeResourcePath.substring(0, relativeResourcePath.length() - 1);
        }
        if ((iconResource = this.iconProvider.getIcon(size = this.getInt((parts = relativeResourcePath.split("/"))[0]), iconId = parts[parts.length - 1])) != null) {
            return new Resource(){

                @Override
                public InputStream getInputStream() {
                    return iconResource.getInputStream();
                }

                @Override
                public long getLength() {
                    return iconResource.getLength();
                }

                @Override
                public Date getLastModified() {
                    return iconResource.getLastModified();
                }

                @Override
                public Date getExpires() {
                    return iconResource.getExpires();
                }

                @Override
                public String getMimeType() {
                    return iconResource.getMimeType();
                }
            };
        }
        return null;
    }

    private int getInt(String s) {
        if (s == null) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public void registerStandardIconProvider(IconProvider iconProvider) {
        this.iconProvider.registerStandardIconProvider(iconProvider);
    }

    public void registerCustomIconProvider(IconProvider iconProvider) {
        this.iconProvider.registerCustomIconProvider(iconProvider);
    }

    public void registerCustomIconStyle(CustomIconStyle customIconStyle) {
        this.iconProvider.registerCustomIconStyle(customIconStyle);
    }
}

