/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.webcontroller;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.teamapps.common.format.Color;
import org.teamapps.icons.api.IconTheme;
import org.teamapps.icons.api.IconThemeImpl;
import org.teamapps.icons.provider.IconProvider;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class SimpleWebController
implements WebController {
    public static final String BACKGROUND_DEFAULT = "default";
    private final Function<SessionContext, Component> componentSupplier;
    private boolean showBackgroundImage;
    private Color defaultBackgroundColor;
    private List<IconProvider> additionalIconProvider = new ArrayList<IconProvider>();
    private IconProvider defaultIconProvider;
    private IconTheme defaultIconTheme;

    public static SimpleWebController createDefaultController(Function<SessionContext, Component> componentSupplier) {
        SimpleWebController webController = new SimpleWebController(componentSupplier);
        return webController;
    }

    public SimpleWebController(Function<SessionContext, Component> componentSupplier) {
        this.componentSupplier = componentSupplier;
    }

    public void setShowBackgroundImage(boolean showBackgroundImage) {
        this.showBackgroundImage = showBackgroundImage;
    }

    public void setDefaultBackgroundColor(Color defaultBackgroundColor) {
        this.defaultBackgroundColor = defaultBackgroundColor;
    }

    public void addAdditionalIconProvider(IconProvider iconProvider) {
        this.additionalIconProvider.add(iconProvider);
    }

    public void setDefaultIconProvider(IconProvider defaultIconProvider) {
        this.defaultIconProvider = defaultIconProvider;
    }

    public void setDefaultIconTheme(IconTheme defaultIconTheme) {
        this.defaultIconTheme = defaultIconTheme;
    }

    @Override
    public IconTheme getDefaultIconTheme(boolean isMobile) {
        if (this.defaultIconTheme != null) {
            return this.defaultIconTheme;
        }
        if (this.defaultIconProvider != null) {
            return new IconThemeImpl(isMobile ? this.defaultIconProvider.getDefaultMobileStyle() : this.defaultIconProvider.getDefaultDesktopStyle(), this.defaultIconProvider.getDefaultSubIconStyle());
        }
        return WebController.super.getDefaultIconTheme(isMobile);
    }

    @Override
    public IconProvider getIconProvider() {
        if (this.defaultIconProvider != null) {
            return this.defaultIconProvider;
        }
        return WebController.super.getIconProvider();
    }

    @Override
    public List<IconProvider> getAdditionalIconProvider() {
        return this.additionalIconProvider;
    }

    @Override
    public void onSessionStart(SessionContext context) {
        if (this.showBackgroundImage) {
            String defaultBackground = "/resources/backgrounds/default-bl.jpg";
            context.registerBackgroundImage(BACKGROUND_DEFAULT, defaultBackground, defaultBackground);
        }
        RootPanel rootPanel = new RootPanel();
        context.addRootComponent(null, rootPanel);
        rootPanel.setContent(this.componentSupplier.apply(context));
        if (this.defaultBackgroundColor != null) {
            context.setBackgroundColor(this.defaultBackgroundColor, 0);
        }
        if (this.showBackgroundImage) {
            context.setBackgroundImage(BACKGROUND_DEFAULT, 0);
        }
    }
}

