/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.uisession.statistics;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicLong;
import org.teamapps.uisession.statistics.ImmutableUiSessionStats;
import org.teamapps.uisession.statistics.SumStats;

public class TrafficStats
implements SumStats {
    private long total;
    private final AtomicLong currentChunkSum = new AtomicLong();
    private final Deque<Long> sum10sChunks = new ArrayDeque<Long>(6);
    private long sumLast10Seconds;
    private long sumLastMinute;

    public void add(long size) {
        this.total += size;
        this.currentChunkSum.addAndGet(size);
    }

    public void flush() {
        while (this.sum10sChunks.size() >= 6) {
            this.sum10sChunks.removeFirst();
        }
        long currentChunkSum = this.currentChunkSum.getAndSet(0L);
        this.sum10sChunks.addLast(currentChunkSum);
        this.sumLastMinute = this.sum10sChunks.stream().mapToLong(value -> value).sum();
        this.sumLast10Seconds = currentChunkSum;
    }

    @Override
    public long getSum() {
        return this.total;
    }

    @Override
    public long getSumLastMinute() {
        return this.sumLastMinute;
    }

    @Override
    public long getSumLast10Seconds() {
        return this.sumLast10Seconds;
    }

    public ImmutableUiSessionStats.ImmutableSumStats toImmutable() {
        return new ImmutableUiSessionStats.ImmutableSumStats(this.total, this.sumLastMinute, this.sumLast10Seconds);
    }
}

