/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teamapps.ux.session.ClientGeoIpInfo;
import org.teamapps.ux.session.ClientUserAgent;

public class ClientInfo {
    private final String ip;
    private final int screenWidth;
    private final int screenHeight;
    private final int viewPortWidth;
    private final int viewPortHeight;
    private final String preferredLanguageIso;
    private final boolean highDensityScreen;
    private final String timeZone;
    private final int timeZoneOffsetMinutes;
    private final Set<String> clientTokens;
    private final String userAgent;
    private final String clientUrl;
    private final Map<String, Object> clientParameters;
    private final String teamAppsVersion;
    private ClientUserAgent userAgentData;
    private ClientGeoIpInfo geoIpInfo;

    public ClientInfo(String ip, int screenWidth, int screenHeight, int viewPortWidth, int viewPortHeight, String preferredLanguageIso, boolean highDensityScreen, String timeZone, int timeZoneOffsetMinutes, List<String> clientTokens, String userAgent, String clientUrl, Map<String, Object> clientParameters, String teamAppsVersion) {
        this.ip = ip;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.viewPortWidth = viewPortWidth;
        this.viewPortHeight = viewPortHeight;
        this.preferredLanguageIso = preferredLanguageIso;
        this.highDensityScreen = highDensityScreen;
        this.timeZone = timeZone;
        this.timeZoneOffsetMinutes = timeZoneOffsetMinutes;
        this.clientTokens = new HashSet<String>(clientTokens);
        this.userAgent = userAgent;
        this.clientUrl = clientUrl;
        this.clientParameters = clientParameters;
        this.teamAppsVersion = teamAppsVersion;
    }

    public boolean isMobileDevice() {
        int screenResolution = Math.max(this.getScreenWidth(), this.getScreenHeight());
        if (screenResolution < 700) {
            return true;
        }
        return this.userAgent != null && this.userAgent.toLowerCase().contains(" mobile");
    }

    public String getIp() {
        return this.ip;
    }

    public ClientGeoIpInfo getGeoIpInfo() {
        return this.geoIpInfo;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getViewPortWidth() {
        return this.viewPortWidth;
    }

    public int getViewPortHeight() {
        return this.viewPortHeight;
    }

    public String getPreferredLanguageIso() {
        return this.preferredLanguageIso;
    }

    public boolean isHighDensityScreen() {
        return this.highDensityScreen;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public int getTimeZoneOffsetMinutes() {
        return this.timeZoneOffsetMinutes;
    }

    public Set<String> getClientTokens() {
        return this.clientTokens;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getClientUrl() {
        return this.clientUrl;
    }

    public Map<String, Object> getClientParameters() {
        return this.clientParameters;
    }

    public ClientUserAgent getUserAgentData() {
        return this.userAgentData;
    }

    public void setUserAgentData(ClientUserAgent userAgentData) {
        this.userAgentData = userAgentData;
    }

    public void setGeoIpInfo(ClientGeoIpInfo geoIpInfo) {
        this.geoIpInfo = geoIpInfo;
    }
}

