/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.absolutelayout;

import org.teamapps.ux.component.absolutelayout.SizeUnit;

public class Length {
    public static final Length AUTO = new Length(-1.0f){

        @Override
        public String toCssString() {
            return "auto";
        }
    };
    private final float size;
    private final SizeUnit unit;

    public static Length ofPixels(int pixels) {
        return new Length(pixels, SizeUnit.PIXEL);
    }

    public static Length ofPercent(int percent) {
        return new Length(percent, SizeUnit.PERCENT);
    }

    public Length(float size) {
        this(size, SizeUnit.PIXEL);
    }

    public Length(float size, SizeUnit unit) {
        this.size = size;
        this.unit = unit;
    }

    public String toCssString() {
        return this.size + this.unit.getCcsString();
    }

    public float getSize() {
        return this.size;
    }

    public SizeUnit getUnit() {
        return this.unit;
    }
}

