/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.chat;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiChatDisplay;
import org.teamapps.dto.UiChatFile;
import org.teamapps.dto.UiChatMessage;
import org.teamapps.dto.UiChatMessageBatch;
import org.teamapps.dto.UiChatPhoto;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiQuery;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icon.material.MaterialIconStyles;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.chat.ChatDisplayModel;
import org.teamapps.ux.component.chat.ChatFile;
import org.teamapps.ux.component.chat.ChatMessage;
import org.teamapps.ux.component.chat.ChatMessageBatch;
import org.teamapps.ux.component.chat.ChatPhoto;

public class ChatDisplay
extends AbstractComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ChatDisplayModel model;
    private int messagesFetchSize = 50;
    private int earliestKnownMessageId = Integer.MAX_VALUE;
    private Icon<?, ?> deletedMessageIcon = MaterialIcon.DELETE.withStyle(MaterialIconStyles.OUTLINE_GREY_900);
    private Function<ChatMessage, CompletableFuture<Component>> contextMenuProvider = null;

    public ChatDisplay(ChatDisplayModel model) {
        this.model = model;
        model.onMessagesAdded().addListener(chatMessages -> {
            this.updateEarliestKnownMessageId((ChatMessageBatch)chatMessages);
            this.queueCommandIfRendered(() -> new UiChatDisplay.AddMessagesCommand(this.getId(), this.createUiChatMessageBatch((ChatMessageBatch)chatMessages)));
        });
        model.onMessageChanged().addListener(chatMessage -> {
            if (this.earliestKnownMessageId <= chatMessage.getId()) {
                this.queueCommandIfRendered(() -> new UiChatDisplay.UpdateMessageCommand(this.getId(), this.createUiChatMessage((ChatMessage)chatMessage)));
            }
        });
        model.onMessageDeleted().addListener(messageId -> {
            if (this.earliestKnownMessageId <= messageId) {
                this.queueCommandIfRendered(() -> new UiChatDisplay.DeleteMessageCommand(this.getId(), messageId.intValue()));
            }
        });
        model.onAllDataChanged().addListener(aVoid -> {
            ChatMessageBatch messageBatch = this.getModel().getLastChatMessages(this.messagesFetchSize);
            this.earliestKnownMessageId = Integer.MAX_VALUE;
            this.updateEarliestKnownMessageId(messageBatch);
            this.queueCommandIfRendered(() -> new UiChatDisplay.ClearMessagesCommand(this.getId(), this.createUiChatMessageBatch(messageBatch)));
        });
    }

    public UiChatDisplay createUiComponent() {
        UiChatDisplay uiChatDisplay = new UiChatDisplay();
        this.mapAbstractUiComponentProperties((UiComponent)uiChatDisplay);
        ChatMessageBatch modelResponse = this.model.getLastChatMessages(this.messagesFetchSize);
        this.updateEarliestKnownMessageId(modelResponse);
        uiChatDisplay.setInitialMessages(this.createUiChatMessageBatch(modelResponse));
        uiChatDisplay.setContextMenuEnabled(this.contextMenuProvider != null);
        uiChatDisplay.setDeletedMessageIcon(this.getSessionContext().resolveIcon(this.deletedMessageIcon));
        return uiChatDisplay;
    }

    private void updateEarliestKnownMessageId(ChatMessageBatch response) {
        this.earliestKnownMessageId = response.getEarliestMessageId() != null && response.getEarliestMessageId() < this.earliestKnownMessageId ? response.getEarliestMessageId() : this.earliestKnownMessageId;
    }

    @Override
    public Object handleUiQuery(UiQuery query) {
        switch (query.getUiQueryType()) {
            case UI_CHAT_DISPLAY_REQUEST_PREVIOUS_MESSAGES: {
                ChatMessageBatch response = this.model.getPreviousMessages(this.earliestKnownMessageId, this.messagesFetchSize);
                this.updateEarliestKnownMessageId(response);
                return this.createUiChatMessageBatch(response);
            }
            case UI_CHAT_DISPLAY_REQUEST_CONTEXT_MENU: {
                UiChatDisplay.RequestContextMenuQuery q = (UiChatDisplay.RequestContextMenuQuery)query;
                ChatMessage chatMessage = this.model.getChatMessageById(q.getChatMessageId());
                if (chatMessage == null) break;
                return ((CompletableFuture)this.contextMenuProvider.apply(chatMessage).thenCompose(component -> {
                    if (component != null) {
                        return this.getSessionContext().runWithContext(component::createUiReference);
                    }
                    return null;
                })).exceptionally(throwable -> {
                    LOGGER.error("Exception in contextMenuProvider!", throwable);
                    return null;
                });
            }
        }
        return super.handleUiQuery(query);
    }

    private List<UiChatMessage> createUiChatMessages(List<ChatMessage> chatMessages) {
        return chatMessages.stream().map(message -> this.createUiChatMessage((ChatMessage)message)).collect(Collectors.toList());
    }

    private UiChatMessageBatch createUiChatMessageBatch(ChatMessageBatch batch) {
        List uiMessages = batch.getMessages().stream().map(this::createUiChatMessage).collect(Collectors.toList());
        return new UiChatMessageBatch(uiMessages, batch.isContainsFirstMessage());
    }

    private UiChatMessage createUiChatMessage(ChatMessage message) {
        UiChatMessage uiChatMessage = new UiChatMessage();
        uiChatMessage.setId(message.getId());
        uiChatMessage.setUserNickname(message.getUserNickname());
        uiChatMessage.setUserImageUrl(message.getUserImage().getUrl(this.getSessionContext()));
        uiChatMessage.setText(message.getText());
        uiChatMessage.setPhotos(message.getPhotos() != null ? message.getPhotos().stream().map(photo -> this.createUiChatPhoto((ChatPhoto)photo)).collect(Collectors.toList()) : null);
        uiChatMessage.setFiles(message.getFiles() != null ? message.getFiles().stream().map(file -> this.createUiChatFile((ChatFile)file)).collect(Collectors.toList()) : null);
        uiChatMessage.setDeleted(message.isDeleted());
        return uiChatMessage;
    }

    private UiChatPhoto createUiChatPhoto(ChatPhoto photo) {
        UiChatPhoto uiChatPhoto = new UiChatPhoto();
        uiChatPhoto.setThumbnailUrl(photo.getThumbnail() != null ? photo.getThumbnail().getUrl(this.getSessionContext()) : null);
        uiChatPhoto.setImageUrl(photo.getImage().getUrl(this.getSessionContext()));
        return uiChatPhoto;
    }

    private UiChatFile createUiChatFile(ChatFile file) {
        UiChatFile uiChatFile = new UiChatFile();
        uiChatFile.setName(file.getName());
        uiChatFile.setIcon(this.getSessionContext().resolveIcon(file.getIcon()));
        uiChatFile.setLength(file.getLength());
        uiChatFile.setThumbnailUrl(file.getThumbnail() != null ? file.getThumbnail().getUrl(this.getSessionContext()) : null);
        uiChatFile.setDownloadUrl(file.getDownload().getUrl(this.getSessionContext()));
        return uiChatFile;
    }

    public ChatDisplayModel getModel() {
        return this.model;
    }

    public int getMessagesFetchSize() {
        return this.messagesFetchSize;
    }

    public void setMessagesFetchSize(int messagesFetchSize) {
        this.messagesFetchSize = messagesFetchSize;
        this.reRenderIfRendered();
    }

    public Function<ChatMessage, CompletableFuture<Component>> getContextMenuProvider() {
        return this.contextMenuProvider;
    }

    public void setContextMenuProvider(Function<ChatMessage, CompletableFuture<Component>> contextMenuProvider) {
        this.contextMenuProvider = contextMenuProvider;
    }

    public void closeContextMenu() {
        this.queueCommandIfRendered(() -> new UiChatDisplay.CloseContextMenuCommand(this.getId()));
    }

    public Icon<?, ?> getDeletedMessageIcon() {
        return this.deletedMessageIcon;
    }

    public void setDeletedMessageIcon(Icon<?, ?> deletedMessageIcon) {
        this.deletedMessageIcon = deletedMessageIcon;
    }
}

