/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.common.format.Color;
import org.teamapps.ux.component.form.ResponsiveFormConfigurationTemplate;
import org.teamapps.ux.component.form.ResponsiveFormField;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.form.layoutpolicy.FormSection;
import org.teamapps.ux.component.form.layoutpolicy.FormSectionFieldPlacement;
import org.teamapps.ux.component.format.Border;
import org.teamapps.ux.component.format.Shadow;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.grid.layout.GridColumn;
import org.teamapps.ux.component.grid.layout.GridRow;
import org.teamapps.ux.component.template.Template;

public class ResponsiveFormSection {
    private final ResponsiveFormLayout formLayout;
    private final String id;
    private Spacing margin;
    private Spacing padding;
    private Border border;
    private Shadow shadow;
    private boolean drawHeaderLine;
    private Color backgroundColor;
    private boolean collapsible;
    private boolean collapsed;
    private boolean visible = true;
    private Template headerTemplate;
    private Object headerData;
    private int gridGap;
    private boolean fillRemainingHeight;
    private boolean hideWhenNoVisibleFields;
    private int minimalNumberOfColumns;
    private int minimalNumberOfRow;
    private final Map<Integer, GridRow> rowMap = new HashMap<Integer, GridRow>();
    private final Map<Integer, GridColumn> columnMap = new HashMap<Integer, GridColumn>();
    private final List<ResponsiveFormField> responsiveFormFields = new ArrayList<ResponsiveFormField>();
    private final ResponsiveFormConfigurationTemplate configurationTemplate;

    protected ResponsiveFormSection(ResponsiveFormLayout formLayout, String id, ResponsiveFormConfigurationTemplate configurationTemplate) {
        this.formLayout = formLayout;
        this.id = id;
        this.configurationTemplate = configurationTemplate;
        this.setTemplate();
    }

    private ResponsiveFormSection setTemplate() {
        FormSection sectionTemplate = this.configurationTemplate.getSectionTemplate();
        if (sectionTemplate == null) {
            return this;
        }
        this.setMargin(sectionTemplate.getMargin());
        this.setPadding(sectionTemplate.getPadding());
        this.setBorder(sectionTemplate.getBorder());
        this.setShadow(sectionTemplate.getShadow());
        this.setDrawHeaderLine(sectionTemplate.isDrawHeaderLine());
        this.setBackgroundColor(sectionTemplate.getBackgroundColor());
        this.setCollapsible(sectionTemplate.isCollapsible());
        this.setCollapsed(sectionTemplate.isCollapsed());
        this.setVisible(sectionTemplate.isVisible());
        this.setHeaderTemplate(sectionTemplate.getHeaderTemplate());
        this.setHeaderData(sectionTemplate.getHeaderData());
        this.setGridGap(sectionTemplate.getGridGap());
        this.setFillRemainingHeight(sectionTemplate.isFillRemainingHeight());
        this.setHideWhenNoVisibleFields(sectionTemplate.isHideWhenNoVisibleFields());
        return this;
    }

    protected ResponsiveFormSection addField(ResponsiveFormField field) {
        this.responsiveFormFields.add(field);
        int row = field.getRow();
        int column = field.getColumn();
        GridRow rowTemplate = this.configurationTemplate.createRowTemplate(false, false);
        GridColumn columnTemplate = this.configurationTemplate.createColumnTemplate(column, false, false);
        if (!this.rowMap.containsKey(row)) {
            this.rowMap.put(row, rowTemplate);
        }
        if (!this.columnMap.containsKey(column)) {
            this.columnMap.put(column, columnTemplate);
        }
        return this;
    }

    protected int getLastNonEmptyRow() {
        return this.rowMap.keySet().stream().max(Integer::compareTo).orElse(-1);
    }

    protected int getLastNonEmptyColumnInRow(int row) {
        return this.responsiveFormFields.stream().filter(field -> field.getRow() == row).map(field -> field.getColumn() + field.getColSpan() - 1).max(Integer::compareTo).orElse(-1);
    }

    protected int getLastNonEmptyColumn() {
        return this.responsiveFormFields.stream().map(field -> field.getColumn() + field.getColSpan() - 1).max(Integer::compareTo).orElse(-1);
    }

    public GridRow getRow(int row) {
        GridRow sectionRow = this.rowMap.get(row);
        if (sectionRow == null) {
            sectionRow = new GridRow();
            this.rowMap.put(row, sectionRow);
        }
        return sectionRow;
    }

    public GridColumn getColumn(int column) {
        GridColumn sectionColumn = this.columnMap.get(column);
        if (sectionColumn == null) {
            sectionColumn = new GridColumn();
            this.columnMap.put(column, sectionColumn);
        }
        return sectionColumn;
    }

    public void setRowConfig(int row, GridRow rowConfig) {
        this.rowMap.put(row, rowConfig);
    }

    public void setColumnConfig(int colum, GridColumn columnConfig) {
        this.columnMap.put(colum, columnConfig);
    }

    protected Map<Integer, GridRow> getRowMap() {
        return this.rowMap;
    }

    protected Map<Integer, GridColumn> getColumnMap() {
        return this.columnMap;
    }

    public List<ResponsiveFormField> getResponsiveFormFields() {
        return this.responsiveFormFields;
    }

    public String getId() {
        return this.id;
    }

    public Spacing getMargin() {
        return this.margin;
    }

    public ResponsiveFormSection setMargin(Spacing margin) {
        this.margin = margin;
        return this;
    }

    public Spacing getPadding() {
        return this.padding;
    }

    public ResponsiveFormSection setPadding(Spacing padding) {
        this.padding = padding;
        return this;
    }

    public Border getBorder() {
        return this.border;
    }

    public ResponsiveFormSection setBorder(Border border) {
        this.border = border;
        return this;
    }

    public Shadow getShadow() {
        return this.shadow;
    }

    public ResponsiveFormSection setShadow(Shadow shadow) {
        this.shadow = shadow;
        return this;
    }

    public boolean isDrawHeaderLine() {
        return this.drawHeaderLine;
    }

    public ResponsiveFormSection setDrawHeaderLine(boolean drawHeaderLine) {
        this.drawHeaderLine = drawHeaderLine;
        return this;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public ResponsiveFormSection setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public ResponsiveFormSection setCollapsible(boolean collapsible) {
        this.collapsible = collapsible;
        return this;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public ResponsiveFormSection setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public ResponsiveFormSection setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public Template getHeaderTemplate() {
        return this.headerTemplate;
    }

    public ResponsiveFormSection setHeaderTemplate(Template headerTemplate) {
        this.headerTemplate = headerTemplate;
        return this;
    }

    public Object getHeaderData() {
        return this.headerData;
    }

    public ResponsiveFormSection setHeaderData(Object headerData) {
        this.headerData = headerData;
        return this;
    }

    public int getGridGap() {
        return this.gridGap;
    }

    public ResponsiveFormSection setGridGap(int gridGap) {
        this.gridGap = gridGap;
        return this;
    }

    public boolean isFillRemainingHeight() {
        return this.fillRemainingHeight;
    }

    public ResponsiveFormSection setFillRemainingHeight(boolean fillRemainingHeight) {
        this.fillRemainingHeight = fillRemainingHeight;
        return this;
    }

    public boolean isHideWhenNoVisibleFields() {
        return this.hideWhenNoVisibleFields;
    }

    public ResponsiveFormSection setHideWhenNoVisibleFields(boolean hideWhenNoVisibleFields) {
        this.hideWhenNoVisibleFields = hideWhenNoVisibleFields;
        return this;
    }

    public int getMinimalNumberOfColumns() {
        return this.minimalNumberOfColumns;
    }

    public void setMinimalNumberOfColumns(int minimalNumberOfColumns) {
        this.minimalNumberOfColumns = minimalNumberOfColumns;
    }

    public int getMinimalNumberOfRow() {
        return this.minimalNumberOfRow;
    }

    public void setMinimalNumberOfRow(int minimalNumberOfRow) {
        this.minimalNumberOfRow = minimalNumberOfRow;
    }

    protected FormSection createFormSection() {
        FormSection formSection = this.createBaseFormSection();
        int maxRow = this.rowMap.keySet().stream().mapToInt(value -> value).max().orElse(0);
        maxRow = Math.max(this.minimalNumberOfRow, maxRow);
        for (int i = 0; i <= maxRow; ++i) {
            GridRow sectionRow = this.rowMap.get(i);
            if (sectionRow == null) {
                sectionRow = this.configurationTemplate.createRowTemplate(true, false);
            }
            formSection.getRows().add(sectionRow);
        }
        int maxColumn = this.columnMap.keySet().stream().mapToInt(value -> value).max().orElse(0);
        maxColumn = Math.max(this.minimalNumberOfColumns, maxColumn);
        for (int i = 0; i <= maxColumn; ++i) {
            GridColumn sectionColumn = this.columnMap.get(i);
            if (sectionColumn == null) {
                sectionColumn = this.configurationTemplate.createColumnTemplate(i, true, false);
            }
            formSection.getColumns().add(sectionColumn);
        }
        this.responsiveFormFields.stream().forEach(field -> formSection.addPlacement(field.createFormSectionPlacement()));
        return formSection;
    }

    protected FormSection createSmallScreenFormSection() {
        FormSection formSection = this.createBaseFormSection();
        this.responsiveFormFields.stream().sorted((o1, o2) -> {
            int rowCompare = Integer.compare(o1.getRow(), o2.getRow());
            if (rowCompare != 0) {
                return rowCompare;
            }
            return Integer.compare(o1.getColumn(), o2.getColumn());
        }).forEach(field -> {
            FormSectionFieldPlacement placement = field.createFormSectionPlacement();
            formSection.addRow(this.getRow(placement.getRow()));
            placement.setColumn(0);
            placement.setRow(formSection.getPlacements().size());
            placement.setRowSpan(1);
            placement.setColSpan(1);
            formSection.add(placement);
        });
        formSection.addColumn(this.configurationTemplate.createColumnTemplate(0, false, true));
        return formSection;
    }

    private FormSection createBaseFormSection() {
        FormSection section = new FormSection(this.id);
        section.setMargin(this.margin);
        section.setPadding(this.padding);
        section.setBorder(this.border);
        section.setShadow(this.shadow);
        section.setDrawHeaderLine(this.drawHeaderLine);
        section.setBackgroundColor(this.backgroundColor);
        section.setCollapsible(this.collapsible);
        section.setCollapsed(this.collapsed);
        section.setVisible(this.visible);
        section.setHeaderTemplate(this.headerTemplate);
        section.setHeaderData(this.headerData);
        section.setGridGap(this.gridGap);
        section.setFillRemainingHeight(this.fillRemainingHeight);
        section.setHideWhenNoVisibleFields(this.hideWhenNoVisibleFields);
        return section;
    }
}

