/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.i18n;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.teamapps.ux.i18n.TeamAppsResourceBundleControl;
import org.teamapps.ux.i18n.TranslationProvider;

public class ResourceBundleTranslationProvider
implements TranslationProvider {
    private final String baseName;
    private final ResourceBundle.Control resourceBundleControl;
    private final Map<Locale, ResourceBundle> resourceBundleByLocale = new HashMap<Locale, ResourceBundle>();

    public ResourceBundleTranslationProvider(String baseName) {
        this(baseName, "properties");
    }

    public ResourceBundleTranslationProvider(String baseName, String resourceFileSuffix) {
        this(baseName, resourceFileSuffix, Locale.getDefault());
    }

    public ResourceBundleTranslationProvider(String baseName, Locale fallbackLocale) {
        this(baseName, "properties", fallbackLocale);
    }

    public ResourceBundleTranslationProvider(String baseName, String resourceFileSuffix, Locale fallbackLocale) {
        this(baseName, new TeamAppsResourceBundleControl(resourceFileSuffix, fallbackLocale));
    }

    public ResourceBundleTranslationProvider(String baseName, ResourceBundle.Control control) {
        this.baseName = baseName;
        this.resourceBundleControl = control;
    }

    @Override
    public String getTranslation(String key, Locale locale) {
        ResourceBundle propertyResourceBundle = this.getResourceBundle(locale);
        return propertyResourceBundle.getString(key);
    }

    public List<String> getKeys(Locale locale) {
        return Collections.list(this.getResourceBundle(locale).getKeys());
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        return this.resourceBundleByLocale.computeIfAbsent(locale, language -> ResourceBundle.getBundle(this.baseName, language, this.resourceBundleControl));
    }
}

