/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.uisession;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.common.TeamAppsVersion;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.core.TeamAppsUploadManager;
import org.teamapps.dto.UiClientInfo;
import org.teamapps.dto.UiRootPanel;
import org.teamapps.dto.UiSessionClosingReason;
import org.teamapps.event.Event;
import org.teamapps.icons.IconProvider;
import org.teamapps.icons.SessionIconProvider;
import org.teamapps.server.UxServerContext;
import org.teamapps.uisession.MessageSender;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.uisession.SessionPair;
import org.teamapps.uisession.UiCommandWithResultCallback;
import org.teamapps.uisession.UiSession;
import org.teamapps.uisession.UiSessionListener;
import org.teamapps.uisession.UiSessionState;
import org.teamapps.uisession.statistics.SessionStatsUpdatedEventData;
import org.teamapps.uisession.statistics.UiSessionStats;
import org.teamapps.util.threading.SequentialExecutorFactory;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.session.ClientInfo;
import org.teamapps.ux.session.SessionConfiguration;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class TeamAppsSessionManager
implements HttpSessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TeamAppsSessionManager.class);
    public static final String TEAMAPPS_VERSION_REFRESH_PARAMETER = "teamappsRefresh";
    public final Event<SessionStatsUpdatedEventData> onStatsUpdated = new Event();
    private final ScheduledExecutorService houseKeepingScheduledExecutor;
    private final ObjectMapper objectMapper;
    private final TeamAppsConfiguration config;
    private final Map<QualifiedUiSessionId, SessionPair> sessionsById = new ConcurrentHashMap<QualifiedUiSessionId, SessionPair>();
    private final Deque<UiSessionStats> closedSessionsStatistics = Queues.synchronizedDeque(new ArrayDeque());
    private final SequentialExecutorFactory sessionExecutorFactory;
    private final WebController webController;
    private final IconProvider iconProvider;
    private final UxServerContext uxServerContext;

    public TeamAppsSessionManager(TeamAppsConfiguration config, ObjectMapper objectMapper, SequentialExecutorFactory sessionExecutorFactory, WebController webController, IconProvider iconProvider, TeamAppsUploadManager uploadManager) {
        this.config = config;
        if (config.getKeepaliveMessageIntervalMillis() >= config.getUiSessionInactivityTimeoutMillis() / 2L) {
            LOGGER.error("keepaliveMessageIntervalMillis should be less than uiSessionInactivityTimeoutMillis / 2!");
        }
        if (config.getUiSessionPreInactivityPingMillis() > config.getUiSessionInactivityTimeoutMillis() / 2L) {
            LOGGER.error("uiSessionPreInactivityPingMillis should not be larger than uiSessionInactivityTimeoutMillis / 2!");
        }
        if (config.getUiSessionInactivityTimeoutMillis() > config.getUiSessionTimeoutMillis()) {
            LOGGER.error("uiSessionInactivityTimeoutMillis must not be greater than uiSessionTimeoutMillis!");
        }
        this.objectMapper = objectMapper;
        this.houseKeepingScheduledExecutor = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("TeamAppsUiSessionManager.houseKeeping");
            thread.setDaemon(true);
            return thread;
        });
        long sessionStateHouseKeepingInterval = Math.min(config.getUiSessionPreInactivityPingMillis() / 2L, config.getUiSessionInactivityTimeoutMillis() / 4L);
        LOGGER.info("sessionStateHouseKeepingInterval: {}ms", (Object)sessionStateHouseKeepingInterval);
        this.houseKeepingScheduledExecutor.scheduleAtFixedRate(() -> {
            try {
                this.updateSessionStates();
            }
            catch (Exception e) {
                LOGGER.error("Exception while updating session states!", (Throwable)e);
            }
        }, sessionStateHouseKeepingInterval, sessionStateHouseKeepingInterval, TimeUnit.MILLISECONDS);
        this.houseKeepingScheduledExecutor.scheduleAtFixedRate(() -> {
            try {
                this.sessionsById.values().forEach(s -> s.getUiSession().updateStats());
                this.onStatsUpdated.fire(new SessionStatsUpdatedEventData(this.getAllSessions(), this.getClosedSessionsStatistics()));
            }
            catch (Exception e) {
                LOGGER.error("Exception while flushing stats!", (Throwable)e);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        this.sessionExecutorFactory = sessionExecutorFactory;
        this.webController = webController;
        this.iconProvider = iconProvider;
        this.uxServerContext = uploadManager::getUploadedFile;
    }

    public UiSession getUiSessionById(QualifiedUiSessionId sessionId) {
        SessionPair sessionPair = this.sessionsById.get(sessionId);
        return sessionPair != null ? sessionPair.getUiSession() : null;
    }

    public SessionContext getSessionContextById(QualifiedUiSessionId sessionId) {
        SessionPair sessionPair = this.sessionsById.get(sessionId);
        return sessionPair != null ? sessionPair.getSessionContext() : null;
    }

    public int getNumberOfSessions() {
        return this.sessionsById.size();
    }

    public List<SessionPair> getAllSessions() {
        return List.copyOf(this.sessionsById.values());
    }

    public int getNumberOfAvailableClosedSessionStatistics() {
        return this.closedSessionsStatistics.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UiSessionStats> getClosedSessionsStatistics() {
        Deque<UiSessionStats> deque = this.closedSessionsStatistics;
        synchronized (deque) {
            return List.copyOf(this.closedSessionsStatistics);
        }
    }

    public void initSession(QualifiedUiSessionId sessionId, UiClientInfo clientInfo, HttpSession httpSession, int maxRequestedCommandId, MessageSender messageSender) {
        LOGGER.trace("initSession: sessionId = [" + sessionId + "], clientInfo = [" + clientInfo + "], maxRequestedCommandId = [" + maxRequestedCommandId + "], messageSender = [" + messageSender + "]");
        final UiSession uiSession = new UiSession(sessionId, System.currentTimeMillis(), this.config, this.objectMapper, messageSender);
        uiSession.addSessionListener(new UiSessionListener(){

            @Override
            public void onStateChanged(QualifiedUiSessionId sessionId, UiSessionState state) {
                if (state == UiSessionState.CLOSED) {
                    TeamAppsSessionManager.this.sessionsById.remove(uiSession.getSessionId());
                    TeamAppsSessionManager.this.closedSessionsStatistics.addLast(uiSession.getStatistics().immutableCopy());
                    while (TeamAppsSessionManager.this.closedSessionsStatistics.size() > 10000) {
                        TeamAppsSessionManager.this.closedSessionsStatistics.removeFirst();
                    }
                }
            }
        });
        SessionContext sessionContext = this.createSessionContext(uiSession, clientInfo, httpSession);
        uiSession.addSessionListener(sessionContext.getAsUiSessionListenerInternal());
        uiSession.handleCommandRequest(maxRequestedCommandId, null);
        boolean wrongTeamappsVersion = clientInfo.getTeamAppsVersion() == null || !Objects.equals(clientInfo.getTeamAppsVersion(), TeamAppsVersion.TEAMAPPS_VERSION) && !Objects.equals(clientInfo.getTeamAppsVersion(), "DEV");
        boolean hasTeamAppsRefreshParameter = clientInfo.getClientParameters().containsKey(TEAMAPPS_VERSION_REFRESH_PARAMETER);
        if (wrongTeamappsVersion) {
            LOGGER.info("Wrong TeamApps client version {} in session {}! Expected: {}!", new Object[]{clientInfo.getTeamAppsVersion(), sessionId, TeamAppsVersion.TEAMAPPS_VERSION});
            if (!hasTeamAppsRefreshParameter) {
                LOGGER.info("Sending redirect with {} parameter.", (Object)TEAMAPPS_VERSION_REFRESH_PARAMETER);
                String separator = StringUtils.isNotEmpty((CharSequence)clientInfo.getLocation().getSearch()) ? "&" : "?";
                uiSession.sendCommand(new UiCommandWithResultCallback(new UiRootPanel.GoToUrlCommand(clientInfo.getLocation().getHref() + separator + "teamappsRefresh=" + System.currentTimeMillis(), false)));
            }
            uiSession.close(UiSessionClosingReason.WRONG_TEAMAPPS_VERSION);
            return;
        }
        this.sessionsById.put(sessionId, new SessionPair(uiSession, sessionContext));
        uiSession.sendInitOk();
        try {
            sessionContext.runWithContext(() -> {
                sessionContext.registerTemplates(Arrays.stream(BaseTemplate.values()).collect(Collectors.toMap(Enum::name, BaseTemplate::getTemplate)));
                this.webController.onSessionStart(sessionContext);
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
        se.getSession().setMaxInactiveInterval(this.config.getHttpSessionTimeoutSeconds());
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.closeAllSessionsForHttpSession(se.getSession().getId());
    }

    public void closeAllSessionsForHttpSession(String httpSessionId) {
        LOGGER.trace("TeamAppsUiSessionManager.removeAllSessionsForHttpSession");
        List sessionsToClose = this.sessionsById.entrySet().stream().filter(e -> ((QualifiedUiSessionId)e.getKey()).getHttpSessionId().equals(httpSessionId)).map(qualifiedUiSessionIdSessionPairEntry -> ((SessionPair)qualifiedUiSessionIdSessionPairEntry.getValue()).getUiSession()).collect(Collectors.toList());
        for (UiSession uiSession : sessionsToClose) {
            uiSession.close(UiSessionClosingReason.HTTP_SESSION_CLOSED);
        }
    }

    public void updateSessionStates() {
        long now = System.currentTimeMillis();
        long nearlyInactiveTimeout = this.config.getUiSessionInactivityTimeoutMillis() - this.config.getUiSessionPreInactivityPingMillis();
        Map<UiSessionState, List<UiSession>> sessionsByActivity = this.sessionsById.values().stream().map(SessionPair::getUiSession).collect(Collectors.groupingBy(session -> {
            long timeSinceLastMessage = now - session.getTimestampOfLastMessageFromClient();
            return timeSinceLastMessage > this.config.getUiSessionInactivityTimeoutMillis() ? UiSessionState.INACTIVE : (timeSinceLastMessage > nearlyInactiveTimeout ? UiSessionState.NEARLY_INACTIVE : UiSessionState.ACTIVE);
        }));
        List sessionsToClose = this.sessionsById.values().stream().map(SessionPair::getUiSession).filter(session -> now - session.getTimestampOfLastMessageFromClient() > this.config.getUiSessionTimeoutMillis()).collect(Collectors.toList());
        for (UiSession inactiveSession : sessionsByActivity.getOrDefault((Object)UiSessionState.INACTIVE, List.of())) {
            if (inactiveSession.getState() == UiSessionState.INACTIVE) continue;
            LOGGER.info("Marking session inactive: {} ({})", (Object)inactiveSession.getName(), (Object)inactiveSession.getSessionId());
            inactiveSession.setInactive();
        }
        for (UiSession criticalSession : sessionsByActivity.getOrDefault((Object)UiSessionState.NEARLY_INACTIVE, List.of())) {
            if (criticalSession.getState() == UiSessionState.NEARLY_INACTIVE) continue;
            LOGGER.info("Marking session nearly inactive and sending PING to client: {} ({})", (Object)criticalSession.getName(), (Object)criticalSession.getSessionId());
            criticalSession.setNearlyInactive();
            criticalSession.ping();
        }
        for (UiSession activeSession : sessionsByActivity.getOrDefault((Object)UiSessionState.ACTIVE, List.of())) {
            if (activeSession.getState() == UiSessionState.ACTIVE) continue;
            LOGGER.info("Marking session active: {} ({})", (Object)activeSession.getName(), (Object)activeSession.getSessionId());
            activeSession.setActive();
        }
        for (UiSession sessionToClose : sessionsToClose) {
            LOGGER.info("Closing session: {} ({})", (Object)sessionToClose.getName(), (Object)sessionToClose.getSessionId());
            sessionToClose.close(UiSessionClosingReason.SESSION_TIMEOUT);
        }
    }

    public void destroy() {
        this.houseKeepingScheduledExecutor.shutdown();
    }

    public SessionContext createSessionContext(UiSession uiSession, UiClientInfo uiClientInfo, HttpSession httpSession) {
        ClientInfo clientInfo = ClientInfo.fromUiClientInfo(uiClientInfo);
        SessionConfiguration sessionConfiguration = SessionConfiguration.createForClientInfo(clientInfo);
        return new SessionContext(uiSession, this.sessionExecutorFactory.createExecutor(uiSession.getSessionId().toString()), clientInfo, sessionConfiguration, httpSession, this.uxServerContext, new SessionIconProvider(this.iconProvider));
    }
}

