/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet;

import java.io.IOException;
import java.io.Reader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiSessionClosingReason;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.uisession.TeamAppsSessionManager;
import org.teamapps.uisession.UiSession;
import org.teamapps.ux.servlet.ServletRequestListener;

public class LeaveBeaconServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletRequestListener.class);
    private final TeamAppsSessionManager uiSessionManager;

    public LeaveBeaconServlet(TeamAppsSessionManager uiSessionManager) {
        this.uiSessionManager = uiSessionManager;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sessionId = IOUtils.toString((Reader)request.getReader());
        LOGGER.info("Got leaving beacon for SessionId: " + sessionId);
        UiSession uiSession = this.uiSessionManager.getUiSessionById(new QualifiedUiSessionId(request.getSession().getId(), sessionId));
        if (uiSession != null) {
            uiSession.close(UiSessionClosingReason.TERMINATED_BY_CLIENT);
        }
    }
}

