/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.server;

import java.util.function.Function;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.resource.ResourceProvider;
import org.teamapps.ux.session.SessionContext;

public class SessionResourceProvider
implements ResourceProvider {
    private final Function<QualifiedUiSessionId, SessionContext> sessionContexts;

    public SessionResourceProvider(Function<QualifiedUiSessionId, SessionContext> sessionContexts) {
        this.sessionContexts = sessionContexts;
    }

    private SessionContext getSessionContext(String resource, String httpSessionId) {
        if (resource == null) {
            return null;
        }
        String[] parts = resource.split("/");
        QualifiedUiSessionId qualifiedUiSessionId = new QualifiedUiSessionId(httpSessionId, parts[0]);
        return this.sessionContexts.apply(qualifiedUiSessionId);
    }

    @Override
    public Resource getResource(String servletPath, String relativeResourcePath, String httpSessionId) {
        try {
            String[] parts;
            QualifiedUiSessionId qualifiedUiSessionId;
            SessionContext sessionContext;
            if (relativeResourcePath == null) {
                return null;
            }
            if (relativeResourcePath.startsWith("/")) {
                relativeResourcePath = relativeResourcePath.substring(1);
            }
            if ((sessionContext = this.sessionContexts.apply(qualifiedUiSessionId = new QualifiedUiSessionId(httpSessionId, (parts = relativeResourcePath.split("/"))[0]))) == null) {
                return null;
            }
            int id = Integer.parseInt(parts[1].substring("res-".length()));
            return sessionContext.getBinaryResource(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

