/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpSession;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.dto.AbstractClientMessage;
import org.teamapps.dto.AbstractServerMessage;
import org.teamapps.dto.CMD_REQUEST;
import org.teamapps.dto.CMD_RESULT;
import org.teamapps.dto.EVENT;
import org.teamapps.dto.INIT;
import org.teamapps.dto.KEEPALIVE;
import org.teamapps.dto.QUERY;
import org.teamapps.dto.REINIT;
import org.teamapps.dto.REINIT_NOK;
import org.teamapps.dto.SESSION_CLOSED;
import org.teamapps.dto.TERMINATE;
import org.teamapps.dto.UiSessionClosingReason;
import org.teamapps.json.TeamAppsObjectMapperFactory;
import org.teamapps.uisession.MessageSender;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.uisession.SendingErrorHandler;
import org.teamapps.uisession.TeamAppsSessionManager;
import org.teamapps.uisession.TeamAppsSessionNotFoundException;
import org.teamapps.uisession.UiSession;
import org.teamapps.ux.servlet.ServerSideClientInfo;
import org.teamapps.ux.servlet.TeamAppsCommunicationException;

public class WebSocketCommunicationEndpoint
extends Endpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketCommunicationEndpoint.class);
    private final ObjectMapper mapper = TeamAppsObjectMapperFactory.create();
    private final AtomicLong totalSendCount = new AtomicLong();
    private final AtomicLong totalReceiveCount = new AtomicLong();
    private final TeamAppsSessionManager sessionManager;
    private final TeamAppsConfiguration teamAppsConfig;

    public WebSocketCommunicationEndpoint(TeamAppsSessionManager sessionManager, TeamAppsConfiguration teamAppsConfig) {
        this.sessionManager = sessionManager;
        this.teamAppsConfig = teamAppsConfig;
    }

    public void onOpen(Session session, EndpointConfig config) {
        session.setMaxIdleTimeout(this.teamAppsConfig.getKeepaliveMessageIntervalMillis() * 3L);
        session.setMaxTextMessageBufferSize(this.teamAppsConfig.getMaxUiClientMessageSize());
        session.addMessageHandler((MessageHandler)new WebSocketHandler(session));
    }

    public void onError(Session session, Throwable thr) {
        LOGGER.warn("WebSocket communication error.", thr);
        this.closeWebSocketSession(session);
    }

    public void onClose(Session session, CloseReason closeReason) {
    }

    private void closeWebSocketSession(Session wsSession) {
        try {
            wsSession.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public long getTotalSendCount() {
        return this.totalSendCount.get();
    }

    public long getTotalReceiveCount() {
        return this.totalReceiveCount.get();
    }

    private class WebSocketHandler
    implements MessageHandler.Whole<String> {
        private final Session wsSession;
        private boolean closed;
        private UiSession uiSession;
        private final AtomicLong sendCount = new AtomicLong();
        private final AtomicLong receivedCount = new AtomicLong();

        public WebSocketHandler(Session session) {
            this.wsSession = session;
        }

        private Optional<UiSession> getUiSession(QualifiedUiSessionId qualifiedUiSessionId) {
            if (this.uiSession != null) {
                return Optional.of(this.uiSession);
            }
            UiSession session = WebSocketCommunicationEndpoint.this.sessionManager.getUiSessionById(qualifiedUiSessionId);
            if (session != null) {
                this.uiSession = session;
            } else {
                LOGGER.warn("Could not find uiSession with id {}", (Object)qualifiedUiSessionId);
            }
            return Optional.ofNullable(session);
        }

        public void onMessage(String payload) {
            block11: {
                this.receivedCount.addAndGet(payload.length());
                WebSocketCommunicationEndpoint.this.totalReceiveCount.addAndGet(payload.length());
                try {
                    HttpSession httpSession = (HttpSession)this.wsSession.getUserProperties().get("HTTP_SESSION");
                    AbstractClientMessage clientMessage = (AbstractClientMessage)WebSocketCommunicationEndpoint.this.mapper.readValue(payload, AbstractClientMessage.class);
                    QualifiedUiSessionId qualifiedUiSessionId = new QualifiedUiSessionId(httpSession.getId(), clientMessage.getSessionId());
                    if (clientMessage instanceof INIT) {
                        ServerSideClientInfo serverSideClientInfo = this.createServerSideClientInfo(this.wsSession);
                        INIT init = (INIT)clientMessage;
                        init.getClientInfo().setIp(serverSideClientInfo.getIp());
                        init.getClientInfo().setUserAgentString(serverSideClientInfo.getUserAgentString());
                        init.getClientInfo().setPreferredLanguageIso(serverSideClientInfo.getPreferredLanguageIso());
                        WebSocketCommunicationEndpoint.this.sessionManager.initSession(qualifiedUiSessionId, init.getClientInfo(), httpSession, init.getMaxRequestedCommandId(), new MessageSenderImpl());
                        break block11;
                    }
                    if (clientMessage instanceof REINIT) {
                        REINIT reinit = (REINIT)clientMessage;
                        this.getUiSession(qualifiedUiSessionId).ifPresentOrElse(uiSession -> uiSession.reinit(reinit.getLastReceivedCommandId(), reinit.getMaxRequestedCommandId(), new MessageSenderImpl()), () -> {
                            LOGGER.warn("Could not find teamAppsUiSession for REINIT: " + qualifiedUiSessionId);
                            this.send((AbstractServerMessage)new REINIT_NOK(UiSessionClosingReason.SESSION_NOT_FOUND), null, null);
                        });
                        break block11;
                    }
                    if (clientMessage instanceof TERMINATE) {
                        this.getUiSession(qualifiedUiSessionId).ifPresent(uiSession -> uiSession.close(UiSessionClosingReason.TERMINATED_BY_CLIENT));
                        break block11;
                    }
                    if (clientMessage instanceof EVENT) {
                        EVENT eventMessage = (EVENT)clientMessage;
                        this.getUiSession(qualifiedUiSessionId).ifPresent(uiSession -> uiSession.handleEvent(eventMessage.getId(), eventMessage.getUiEvent()));
                        break block11;
                    }
                    if (clientMessage instanceof QUERY) {
                        QUERY queryMessage = (QUERY)clientMessage;
                        this.getUiSession(qualifiedUiSessionId).ifPresent(uiSession -> uiSession.handleQuery(queryMessage.getId(), queryMessage.getUiQuery()));
                        break block11;
                    }
                    if (clientMessage instanceof CMD_RESULT) {
                        CMD_RESULT cmdResult = (CMD_RESULT)clientMessage;
                        this.getUiSession(qualifiedUiSessionId).ifPresent(uiSession -> uiSession.handleCommandResult(cmdResult.getId(), cmdResult.getCmdId(), cmdResult.getResult()));
                        break block11;
                    }
                    if (clientMessage instanceof CMD_REQUEST) {
                        CMD_REQUEST cmdRequest = (CMD_REQUEST)clientMessage;
                        this.getUiSession(qualifiedUiSessionId).ifPresent(uiSession -> uiSession.handleCommandRequest(cmdRequest.getMaxRequestedCommandId(), cmdRequest.getLastReceivedCommandId()));
                        break block11;
                    }
                    if (clientMessage instanceof KEEPALIVE) {
                        this.getUiSession(qualifiedUiSessionId).ifPresent(UiSession::handleKeepAlive);
                        break block11;
                    }
                    throw new TeamAppsCommunicationException("Unknown message type: " + clientMessage.getClass().getCanonicalName());
                }
                catch (TeamAppsSessionNotFoundException e) {
                    LOGGER.warn("TeamApps session not found: " + e.getSessionId());
                    this.send((AbstractServerMessage)new SESSION_CLOSED(UiSessionClosingReason.SESSION_NOT_FOUND).setMessage(e.getMessage()), this::close, t -> this.close());
                }
                catch (Exception e) {
                    LOGGER.error("Exception while processing client message!", (Throwable)e);
                    this.send((AbstractServerMessage)new SESSION_CLOSED(UiSessionClosingReason.SERVER_SIDE_ERROR).setMessage(e.getMessage()), this::close, t -> this.close());
                }
            }
        }

        private void send(AbstractServerMessage message, final Runnable sendingSuccessHandler, final SendingErrorHandler sendingErrorHandler) {
            block5: {
                if (this.closed) {
                    sendingErrorHandler.onErrorWhileSending(new TeamAppsCommunicationException("Connection closed!"));
                    return;
                }
                try {
                    String messageAsString;
                    try {
                        messageAsString = WebSocketCommunicationEndpoint.this.mapper.writeValueAsString((Object)message);
                    }
                    catch (JsonProcessingException e) {
                        throw new TeamAppsCommunicationException(e);
                    }
                    this.sendCount.addAndGet(messageAsString.length());
                    WebSocketCommunicationEndpoint.this.totalSendCount.addAndGet(messageAsString.length());
                    this.wsSession.getAsyncRemote().sendText(messageAsString, new SendHandler(){

                        public void onResult(SendResult result) {
                            if (result.isOK() && sendingSuccessHandler != null) {
                                sendingSuccessHandler.run();
                            }
                            if (!result.isOK() && sendingErrorHandler != null) {
                                sendingErrorHandler.onErrorWhileSending(result.getException());
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (sendingErrorHandler == null) break block5;
                    sendingErrorHandler.onErrorWhileSending(e);
                }
            }
        }

        private ServerSideClientInfo createServerSideClientInfo(Session session) {
            Map attributes = session.getUserProperties();
            return new ServerSideClientInfo((String)attributes.get("CLIENT_IP"), (String)attributes.get("USER_AGENT"), (String)attributes.get("LANGUAGE"));
        }

        private void close() {
            this.closed = true;
            WebSocketCommunicationEndpoint.this.closeWebSocketSession(this.wsSession);
        }

        private class MessageSenderImpl
        implements MessageSender {
            private MessageSenderImpl() {
            }

            @Override
            public void sendMessageAsynchronously(AbstractServerMessage msg, SendingErrorHandler sendingErrorHandler) {
                WebSocketHandler.this.send(msg, null, sendingErrorHandler);
            }

            @Override
            public void close(UiSessionClosingReason closingReason, String message) {
                WebSocketHandler.this.send((AbstractServerMessage)new SESSION_CLOSED(closingReason).setMessage(message), () -> WebSocketHandler.this.close(), t -> WebSocketHandler.this.close());
            }

            @Override
            public long getDataReceived() {
                return WebSocketHandler.this.receivedCount.get();
            }

            @Override
            public long getDataSent() {
                return WebSocketHandler.this.sendCount.get();
            }
        }
    }
}

