/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.charting.pie;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.teamapps.dto.AbstractUiChart;
import org.teamapps.dto.UiChartNamedDataPoint;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiPieChart;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.charting.ChartLegendStyle;
import org.teamapps.ux.component.charting.DataPointWeighting;
import org.teamapps.ux.component.charting.pie.ChartNamedDataPoint;

public class PieChart
extends AbstractComponent {
    public final Event<ChartNamedDataPoint> onDataPointClicked = new Event();
    private long animationDuration = 500L;
    private ChartLegendStyle legendStyle;
    private DataPointWeighting dataPointWeighting = DataPointWeighting.RELATIVE;
    private float rotation3D = 90.0f;
    private float height3D = 0.0f;
    private float rotationClockwise = 0.0f;
    private float innerRadiusProportion = 0.0f;
    private final List<ChartNamedDataPoint> dataPoints = new ArrayList<ChartNamedDataPoint>();

    public PieChart() {
    }

    public PieChart(List<ChartNamedDataPoint> dataPoints) {
        this.dataPoints.addAll(dataPoints);
    }

    @Override
    public UiComponent createUiComponent() {
        UiPieChart uiPieChart = new UiPieChart();
        uiPieChart.setDataPointWeighting(this.dataPointWeighting.toUiDataPointWeighting());
        uiPieChart.setRotation3D(this.rotation3D);
        uiPieChart.setHeight3D(this.height3D);
        uiPieChart.setRotationClockwise(this.rotationClockwise);
        uiPieChart.setInnerRadiusProportion(this.innerRadiusProportion);
        uiPieChart.setDataPoints(this.createUiDataPoints());
        return uiPieChart;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_PIE_CHART_DATA_POINT_CLICKED: {
                UiPieChart.DataPointClickedEvent clickEvent = (UiPieChart.DataPointClickedEvent)event;
                this.dataPoints.stream().filter(p -> Objects.equals(p.getName(), clickEvent.getDataPointName())).findFirst().ifPresent(this.onDataPointClicked::fire);
            }
        }
    }

    @NotNull
    private List<UiChartNamedDataPoint> createUiDataPoints() {
        return this.dataPoints != null ? this.dataPoints.stream().map(ChartNamedDataPoint::createUiChartNamedDataPoint).collect(Collectors.toList()) : Collections.emptyList();
    }

    public long getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(long animationDuration) {
        this.animationDuration = animationDuration;
    }

    public ChartLegendStyle getLegendStyle() {
        return this.legendStyle;
    }

    public void setLegendStyle(ChartLegendStyle legendStyle) {
        this.legendStyle = legendStyle;
        this.queueCommandIfRendered(() -> new AbstractUiChart.SetLegendStyleCommand(this.getId(), legendStyle.toUiChartLegendStyle()));
    }

    public DataPointWeighting getDataPointWeighting() {
        return this.dataPointWeighting;
    }

    public void setDataPointWeighting(DataPointWeighting dataPointWeighting) {
        this.dataPointWeighting = dataPointWeighting;
        this.queueCommandIfRendered(() -> new UiPieChart.SetDataPointWeightingCommand(this.getId(), dataPointWeighting.toUiDataPointWeighting()));
    }

    public float getRotation3D() {
        return this.rotation3D;
    }

    public void setRotation3D(float rotation3D) {
        this.rotation3D = rotation3D;
        this.queueCommandIfRendered(() -> new UiPieChart.SetRotation3DCommand(this.getId(), rotation3D));
    }

    public float getHeight3D() {
        return this.height3D;
    }

    public void setHeight3D(float height3D) {
        this.height3D = height3D;
        this.queueCommandIfRendered(() -> new UiPieChart.SetHeight3DCommand(this.getId(), height3D));
    }

    public float getRotationClockwise() {
        return this.rotationClockwise;
    }

    public void setRotationClockwise(float rotationClockwise) {
        this.rotationClockwise = rotationClockwise;
        this.queueCommandIfRendered(() -> new UiPieChart.SetRotationClockwiseCommand(this.getId(), rotationClockwise));
    }

    public float getInnerRadiusProportion() {
        return this.innerRadiusProportion;
    }

    public void setInnerRadiusProportion(float innerRadiusProportion) {
        this.innerRadiusProportion = innerRadiusProportion;
        this.queueCommandIfRendered(() -> new UiPieChart.SetInnerRadiusProportionCommand(this.getId(), innerRadiusProportion));
    }

    public List<ChartNamedDataPoint> getDataPoints() {
        return this.dataPoints;
    }

    public void setDataPoints(List<ChartNamedDataPoint> dataPoints) {
        this.dataPoints.clear();
        this.dataPoints.addAll(dataPoints);
        this.queueCommandIfRendered(() -> new UiPieChart.SetDataPointsCommand(this.getId(), this.createUiDataPoints(), this.animationDuration));
    }
}

