/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiComponentField;
import org.teamapps.dto.UiField;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.format.Border;

public class ComponentField
extends AbstractField<Void> {
    private Component component;
    private int width;
    private int height;
    private Border border;
    private Color backgroundColor;

    public ComponentField(Component component) {
        this.component = component;
    }

    public UiField createUiComponent() {
        UiComponentField uiField = new UiComponentField();
        this.mapAbstractFieldAttributesToUiField((UiField)uiField);
        uiField.setComponent(Component.createUiComponentReference(this.component));
        uiField.setWidth(this.width);
        uiField.setHeight(this.height);
        uiField.setBorder(this.border != null ? this.border.createUiBorder() : null);
        uiField.setBackgroundColor(this.backgroundColor != null ? UiUtil.createUiColor(this.backgroundColor) : null);
        return uiField;
    }

    @Override
    protected void doDestroy() {
        this.component.destroy();
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.queueCommandIfRendered(() -> new UiComponentField.SetComponentCommand(this.getId(), Component.createUiComponentReference(component)));
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.queueCommandIfRendered(() -> new UiComponentField.SetSizeCommand(this.getId(), width, this.height));
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
        this.queueCommandIfRendered(() -> new UiComponentField.SetSizeCommand(this.getId(), this.width, height));
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
        this.queueCommandIfRendered(() -> new UiComponentField.SetBorderCommand(this.getId(), border != null ? border.createUiBorder() : null));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.queueCommandIfRendered(() -> new UiComponentField.SetBackgroundColorCommand(this.getId(), backgroundColor != null ? UiUtil.createUiColor(backgroundColor) : null));
    }
}

