/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.datetime;

import java.time.Instant;
import org.teamapps.dto.AbstractUiTimeField;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiInstantDateField;
import org.teamapps.dto.UiInstantTimeField;
import org.teamapps.ux.component.field.TextInputHandlingField;
import org.teamapps.ux.component.field.datetime.AbstractTimeField;

public class InstantTimeField
extends AbstractTimeField<InstantTimeField, Instant>
implements TextInputHandlingField {
    private String timeZoneId = null;

    public UiField createUiComponent() {
        UiInstantTimeField uiTimeField = new UiInstantTimeField();
        this.mapAbstractTimeFieldUiValues((AbstractUiTimeField)uiTimeField);
        uiTimeField.setTimeZoneId(this.timeZoneId);
        return uiTimeField;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
        this.queueCommandIfRendered(() -> new UiInstantDateField.SetTimeZoneIdCommand(this.getId(), timeZoneId));
    }

    @Override
    public Instant convertUiValueToUxValue(Object value) {
        if (value == null) {
            return null;
        }
        return Instant.ofEpochMilli(((Number)value).longValue());
    }
}

