/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.form;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.form.AbstractForm;
import org.teamapps.ux.component.form.ResponsiveFormConfigurationTemplate;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.form.layoutpolicy.FormLayoutPolicy;

public class ResponsiveForm<RECORD>
extends AbstractForm<ResponsiveForm, RECORD> {
    private List<ResponsiveFormLayout> responsiveFormLayouts = new ArrayList<ResponsiveFormLayout>();
    private boolean createSmallScreenLayoutIfMissing = true;
    private ResponsiveFormConfigurationTemplate configurationTemplate = new ResponsiveFormConfigurationTemplate();

    public ResponsiveForm() {
    }

    public ResponsiveForm(ResponsiveFormConfigurationTemplate configurationTemplate) {
        this.configurationTemplate = configurationTemplate;
    }

    public ResponsiveForm(int minLabelWidth, int fieldMinWidth, int fieldMaxWidth) {
        this.configurationTemplate = ResponsiveFormConfigurationTemplate.createDefaultTwoColumnTemplate(minLabelWidth, fieldMinWidth, fieldMaxWidth);
    }

    public ResponsiveFormLayout addResponsiveFormLayout(int minWidth) {
        return this.addResponsiveFormLayout(minWidth, null);
    }

    public ResponsiveFormLayout addResponsiveFormLayout(int minWidth, ResponsiveFormConfigurationTemplate configurationTemplate) {
        if (configurationTemplate == null) {
            configurationTemplate = this.configurationTemplate;
        }
        ResponsiveFormLayout responsiveFormLayout = new ResponsiveFormLayout(minWidth, this, configurationTemplate);
        this.responsiveFormLayouts.add(responsiveFormLayout);
        return responsiveFormLayout;
    }

    protected void addLayoutField(String propertyName, AbstractField field) {
        if (this.getFieldByPropertyName(propertyName) == null) {
            this.addField(propertyName, field);
        }
    }

    protected void addLayoutComponent(Component field) {
        if (!this.getAllChildren().contains(field)) {
            this.addComponent(field);
        }
    }

    @Override
    public List<FormLayoutPolicy> getLayoutPolicies() {
        ArrayList<FormLayoutPolicy> policies = new ArrayList<FormLayoutPolicy>();
        this.responsiveFormLayouts.stream().forEach(responsiveFormLayout -> policies.add(responsiveFormLayout.createFormLayoutPolicy()));
        ResponsiveFormLayout smallestLayout = this.responsiveFormLayouts.stream().sorted(Comparator.comparingInt(ResponsiveFormLayout::getMinWidth)).findFirst().orElseGet(() -> null);
        if (this.createSmallScreenLayoutIfMissing && smallestLayout != null && smallestLayout.getMinWidth() > 0) {
            policies.add(smallestLayout.createSmallScreenLayout());
        }
        return policies;
    }

    public boolean isCreateSmallScreenLayoutIfMissing() {
        return this.createSmallScreenLayoutIfMissing;
    }

    public void setCreateSmallScreenLayoutIfMissing(boolean createSmallScreenLayoutIfMissing) {
        this.createSmallScreenLayoutIfMissing = createSmallScreenLayoutIfMissing;
    }

    public ResponsiveFormConfigurationTemplate getConfigurationTemplate() {
        return this.configurationTemplate;
    }

    public void setConfigurationTemplate(ResponsiveFormConfigurationTemplate configurationTemplate) {
        this.configurationTemplate = configurationTemplate;
    }
}

