/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.teamapps.ux.component.tree.TreeNodeInfo;

public interface TreeNode
extends TreeNodeInfo {
    @Override
    public TreeNode getParent();

    default public int getDepth() {
        TreeNode node = this;
        int i = 0;
        while (node.getParent() != null) {
            ++i;
            node = node.getParent();
        }
        return i;
    }

    default public List<TreeNode> getPath() {
        return TreeNode.getPathToNode(this);
    }

    default public boolean isDescendantOf(TreeNode potentialAncestor) {
        for (TreeNode ancestor = this.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (ancestor != potentialAncestor) continue;
            return true;
        }
        return false;
    }

    default public boolean isDescendantOf(Collection<? extends TreeNode> potentialAncestors) {
        for (TreeNode ancestor = this.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!potentialAncestors.contains(ancestor)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<TreeNode> getPathToNode(TreeNode node) {
        ArrayList<TreeNode> path = new ArrayList<TreeNode>();
        for (TreeNode selfOrAncestor = node; selfOrAncestor != null; selfOrAncestor = selfOrAncestor.getParent()) {
            path.add(selfOrAncestor);
        }
        Collections.reverse(path);
        return path;
    }
}

