/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.notification;

import org.teamapps.common.format.Color;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.dto.UiNotification;
import org.teamapps.icons.api.Icon;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.animation.EntranceAnimation;
import org.teamapps.ux.component.animation.ExitAnimation;
import org.teamapps.ux.component.notification.NotificationPosition;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.template.Template;

public class Notification<RECORD> {
    private Template template;
    private RECORD record;
    private PropertyExtractor<RECORD> propertyExtractor = new BeanPropertyExtractor();
    private NotificationPosition position = NotificationPosition.TOP_RIGHT;
    private Color backgroundColor = Color.WHITE;
    private int displayTimeInMillis = 3000;
    private boolean dismissable = true;
    private boolean showProgressBar = true;
    private EntranceAnimation entranceAnimation = EntranceAnimation.FADE_IN;
    private ExitAnimation exitAnimation = ExitAnimation.FADE_OUT;

    public Notification(RECORD message) {
        this.template = null;
        this.record = message;
    }

    public Notification(Template template, RECORD record) {
        this.template = template;
        this.record = record;
    }

    public static Notification createWithIconAndCaption(Icon icon, String text) {
        return new Notification(BaseTemplate.NOTIFICATION_ICON_CAPTION, new BaseTemplateRecord(icon, text));
    }

    public static Notification createWithIconAndTextAndDescription(Icon icon, String text, String description) {
        return new Notification(BaseTemplate.NOTIFICATION_ICON_CAPTION_DESCRIPTION, new BaseTemplateRecord(icon, text, description));
    }

    public UiNotification createUiNotification() {
        Object values = this.template != null ? this.propertyExtractor.getValues(this.record, this.template.getDataKeys()) : "" + this.record;
        UiNotification uiNotification = new UiNotification(this.template != null ? this.template.createUiTemplate() : null, values);
        uiNotification.setPosition(this.position.toUiNotificationPosition());
        uiNotification.setBackgroundColor(UiUtil.createUiColor(this.backgroundColor));
        uiNotification.setDisplayTimeInMillis(this.displayTimeInMillis);
        uiNotification.setDismissable(this.dismissable);
        uiNotification.setShowProgressBar(this.showProgressBar);
        uiNotification.setEntranceAnimation(this.entranceAnimation != null ? this.entranceAnimation.toUiEntranceAnimation() : null);
        uiNotification.setExitAnimation(this.exitAnimation != null ? this.exitAnimation.toUiExitAnimation() : null);
        return uiNotification;
    }

    public NotificationPosition getPosition() {
        return this.position;
    }

    public Notification setPosition(NotificationPosition position) {
        this.position = position;
        return this;
    }

    public Template getTemplate() {
        return this.template;
    }

    public Notification setTemplate(Template template) {
        this.template = template;
        return this;
    }

    public RECORD getRecord() {
        return this.record;
    }

    public Notification setRecord(RECORD record) {
        this.record = record;
        return this;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Notification setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public int getDisplayTimeInMillis() {
        return this.displayTimeInMillis;
    }

    public Notification setDisplayTimeInMillis(int displayTimeInMillis) {
        this.displayTimeInMillis = displayTimeInMillis;
        return this;
    }

    public boolean isDismissable() {
        return this.dismissable;
    }

    public Notification setDismissable(boolean dismissable) {
        this.dismissable = dismissable;
        return this;
    }

    public boolean isShowProgressBar() {
        return this.showProgressBar;
    }

    public Notification setShowProgressBar(boolean showProgressBar) {
        this.showProgressBar = showProgressBar;
        return this;
    }

    public EntranceAnimation getEntranceAnimation() {
        return this.entranceAnimation;
    }

    public Notification setEntranceAnimation(EntranceAnimation entranceAnimation) {
        this.entranceAnimation = entranceAnimation;
        return this;
    }

    public ExitAnimation getExitAnimation() {
        return this.exitAnimation;
    }

    public Notification setExitAnimation(ExitAnimation exitAnimation) {
        this.exitAnimation = exitAnimation;
        return this;
    }
}

