/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.template.gridtemplate;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.UiGridTemplate;
import org.teamapps.dto.UiTemplate;
import org.teamapps.ux.component.format.SizeType;
import org.teamapps.ux.component.format.SizingPolicy;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.grid.layout.GridColumn;
import org.teamapps.ux.component.grid.layout.GridRow;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.template.gridtemplate.AbstractTemplateElement;

public class GridTemplate
implements Template {
    private int minWidth = 0;
    private int maxWidth = 0;
    private int minHeight = 0;
    private int maxHeight = 0;
    private Spacing padding;
    private int gridGap = 0;
    List<GridColumn> columns = new ArrayList<GridColumn>();
    List<GridRow> rows = new ArrayList<GridRow>();
    List<AbstractTemplateElement<?>> elements = new ArrayList();

    public GridTemplate() {
    }

    public GridTemplate(int minWidth, int maxWidth, int minHeight, int maxHeight, Spacing padding, int gridGap) {
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.padding = padding;
        this.gridGap = gridGap;
    }

    @Override
    public List<String> getDataKeys() {
        return this.elements.stream().flatMap(element -> element.getDataKeys().stream()).distinct().collect(Collectors.toList());
    }

    public GridTemplate addColumn(GridColumn column) {
        this.columns.add(column);
        return this;
    }

    public GridTemplate addColumn(SizingPolicy widthPolicy) {
        this.columns.add(new GridColumn(widthPolicy, 0, 0));
        return this;
    }

    public GridTemplate addColumn(SizingPolicy widthPolicy, int leftPadding, int rightPadding) {
        this.columns.add(new GridColumn(widthPolicy, leftPadding, rightPadding));
        return this;
    }

    public GridTemplate addColumn(SizeType type, float widthValue, int minAbsoluteWidth, int leftPadding, int rightPadding) {
        this.columns.add(new GridColumn(new SizingPolicy(type, widthValue, minAbsoluteWidth), leftPadding, rightPadding));
        return this;
    }

    public GridTemplate addRow(SizingPolicy height) {
        this.rows.add(new GridRow(height, 0, 0));
        return this;
    }

    public GridTemplate addRow(GridRow row) {
        this.rows.add(row);
        return this;
    }

    public GridTemplate addRow(SizingPolicy heightPolicy, int topPadding, int bottomPadding) {
        this.rows.add(new GridRow(heightPolicy, topPadding, bottomPadding));
        return this;
    }

    public GridTemplate addRow(SizeType type, float heightValue, int minAbsoluteHeight, int topPadding, int bottomPadding) {
        this.rows.add(new GridRow(new SizingPolicy(type, heightValue, minAbsoluteHeight), topPadding, bottomPadding));
        return this;
    }

    public GridTemplate setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    public GridTemplate setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public GridTemplate setColumns(List<GridColumn> columns) {
        this.columns = columns;
        return this;
    }

    public GridTemplate setRows(List<GridRow> rows) {
        this.rows = rows;
        return this;
    }

    public GridTemplate setElements(List<AbstractTemplateElement<?>> elements) {
        this.elements = elements;
        return this;
    }

    public GridTemplate addElement(AbstractTemplateElement element) {
        this.elements.add(element);
        return this;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public List<GridColumn> getColumns() {
        return this.columns;
    }

    public List<GridRow> getRows() {
        return this.rows;
    }

    public List<AbstractTemplateElement<?>> getElements() {
        return this.elements;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public GridTemplate setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public GridTemplate setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public Spacing getPadding() {
        return this.padding;
    }

    public GridTemplate setPadding(Spacing padding) {
        this.padding = padding;
        return this;
    }

    public int getGridGap() {
        return this.gridGap;
    }

    public GridTemplate setGridGap(int gridGap) {
        this.gridGap = gridGap;
        return this;
    }

    @Override
    public UiTemplate createUiTemplate() {
        List uiColumns = this.columns.stream().map(column -> column != null ? column.createUiGridColumn() : null).collect(Collectors.toList());
        List uiRows = this.rows.stream().map(row -> row != null ? row.createUiGridRow() : null).collect(Collectors.toList());
        List uiTemplateElements = this.elements.stream().map(element -> element != null ? element.createUiTemplateElement() : null).collect(Collectors.toList());
        UiGridTemplate uiGridTemplate = new UiGridTemplate(uiColumns, uiRows, uiTemplateElements);
        uiGridTemplate.setMinWidth(this.minWidth);
        uiGridTemplate.setMaxWidth(this.maxWidth);
        uiGridTemplate.setMinHeight(this.minHeight);
        uiGridTemplate.setMaxHeight(this.maxHeight);
        if (this.padding != null) {
            uiGridTemplate.setPadding(this.padding.createUiSpacing());
        }
        uiGridTemplate.setGridGap(this.gridGap);
        return uiGridTemplate;
    }
}

