/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.partitioning;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.partitioning.AbstractRawTimedDataModel;

public class StaticRawTimedDataModel
extends AbstractRawTimedDataModel {
    private Map<String, long[]> eventTimestampsByLineId = new HashMap<String, long[]>();
    private Interval staticDomainX;

    public void setEventTimestampsByLineId(Map<String, long[]> eventTimestampsByLineId) {
        this.eventTimestampsByLineId = new HashMap<String, long[]>(eventTimestampsByLineId);
        this.onDataChanged.fire(null);
    }

    public void setEventTimestampsForLineId(String lineId, long[] eventTimestamps) {
        this.eventTimestampsByLineId.put(lineId, eventTimestamps);
        this.onDataChanged.fire(null);
    }

    @Override
    public Map<String, long[]> getRawEventTimes(Collection<String> lineIds, Interval neededIntervalX) {
        return this.eventTimestampsByLineId.entrySet().stream().filter(e -> lineIds.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Interval getDomainX(Collection<String> lineIds) {
        if (this.staticDomainX != null) {
            return this.staticDomainX;
        }
        long min = this.eventTimestampsByLineId.entrySet().stream().filter(e -> lineIds.contains(e.getKey())).flatMapToLong(e -> Arrays.stream((long[])e.getValue())).min().orElse(0L);
        long max = this.eventTimestampsByLineId.entrySet().stream().filter(e -> lineIds.contains(e.getKey())).flatMapToLong(e -> Arrays.stream((long[])e.getValue())).max().orElse(1L);
        return new Interval(min, max);
    }

    public void setStaticDomainX(Interval staticDomainX) {
        this.staticDomainX = staticDomainX;
    }
}

